/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.list;

import com.majruszsdifficulty.GameStage;
import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.gamemodifiers.CustomConditions;
import com.mlib.Random;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.ContextBase;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.gamemodifiers.contexts.OnDeathContext;
import com.mlib.gamemodifiers.data.OnDeathData;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class SpawnPlayerZombie
extends GameModifier {
    final DoubleConfig headChance = new DoubleConfig("head_chance", "Chance for a zombie to have player's head.", false, 1.0, 0.0, 1.0);
    final DoubleConfig headDropChance = new DoubleConfig("head_drop_chance", "Chance for a zombie to drop player's head.", false, 0.1, 0.0, 1.0);

    public SpawnPlayerZombie() {
        super(Registries.Modifiers.DEFAULT, "SpawnPlayerZombie", "If the player dies from a zombie or bleeding, then a zombie with player's name spawns in the same place.");
        OnDeathContext onDeath = new OnDeathContext(this::spawnZombie);
        onDeath.addCondition((Condition)new CustomConditions.GameStage(GameStage.Stage.EXPERT)).addCondition((Condition)new CustomConditions.CRDChance(1.0, false)).addCondition((Condition)new Condition.Excludable()).addCondition(data -> data.level != null).addCondition(data -> data.target instanceof Player).addCondition(data -> data.target.m_21023_((MobEffect)Registries.BLEEDING.get()) || data.attacker instanceof Zombie).addConfigs(new IConfigurable[]{this.headChance, this.headDropChance});
        this.addContext((ContextBase)onDeath);
    }

    private void spawnZombie(OnDeathData data) {
        assert (data.level != null);
        Player player = (Player)data.target;
        EntityType<? extends Zombie> zombieType = SpawnPlayerZombie.getZombieType(data.attacker);
        Zombie zombie = (Zombie)zombieType.m_20592_(data.level, null, null, player.m_20183_(), MobSpawnType.EVENT, true, true);
        if (zombie == null) {
            return;
        }
        if (Random.tryChance((double)((Double)this.headChance.get()))) {
            ItemStack playerSkull = SpawnPlayerZombie.getHead(player);
            zombie.m_8061_(EquipmentSlot.HEAD, playerSkull);
            zombie.m_21409_(EquipmentSlot.HEAD, ((Double)this.headDropChance.get()).floatValue());
        }
        zombie.m_6593_(player.m_7755_());
        zombie.m_21553_(false);
        zombie.m_21530_();
    }

    private static ItemStack getHead(Player player) {
        ItemStack playerSkull = new ItemStack((ItemLike)Items.f_42680_, 1);
        CompoundTag nbt = playerSkull.m_41784_();
        nbt.m_128359_("SkullOwner", player.m_6302_());
        playerSkull.m_41751_(nbt);
        return playerSkull;
    }

    private static EntityType<? extends Zombie> getZombieType(@Nullable LivingEntity attacker) {
        if (attacker instanceof ZombifiedPiglin) {
            return EntityType.f_20531_;
        }
        if (attacker instanceof Husk) {
            return EntityType.f_20458_;
        }
        return EntityType.f_20501_;
    }
}

