/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.undeadarmy.UndeadArmy;
import com.majruszsdifficulty.undeadarmy.UndeadArmyConfig;
import com.majruszsdifficulty.undeadarmy.UndeadArmyManager;
import com.mlib.gamemodifiers.ContextBase;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.gamemodifiers.contexts.OnDeathContext;
import com.mlib.gamemodifiers.contexts.OnEntityTickContext;
import com.mlib.gamemodifiers.contexts.OnServerTickContext;
import com.mlib.gamemodifiers.contexts.OnSpawned;
import com.mlib.gamemodifiers.data.OnDeathData;
import com.mlib.gamemodifiers.data.OnEntityTickData;
import com.mlib.gamemodifiers.data.OnServerTickData;
import com.mlib.levels.LevelHelper;
import com.mlib.nbt.NBTHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;

public class UndeadArmyEventsHandler
extends GameModifier {
    public UndeadArmyEventsHandler() {
        super(Registries.Modifiers.UNDEAD_ARMY, "UndeadArmyEventsHandler", "");
        OnSpawned.Context onLoaded = new OnSpawned.Context(this::resetUndeadArmyGoals);
        onLoaded.addCondition(data -> data.loadedFromDisk && UndeadArmyManager.isUndeadArmy(data.entity));
        OnEntityTickContext onTick = new OnEntityTickContext(this::freezeNearbyWater);
        onTick.addCondition(data -> UndeadArmyManager.isUndeadArmy(data.entity));
        OnDeathContext onArmyProgress = new OnDeathContext(this::updateArmyProgress);
        onArmyProgress.addCondition(data -> UndeadArmyManager.isUndeadArmy(data.entity) && Registries.UNDEAD_ARMY_MANAGER != null);
        OnDeathContext onUndeadKill = new OnDeathContext(this::updateKilledUndead);
        onUndeadKill.addCondition(data -> data.target.m_6336_() == MobType.f_21641_ && Registries.UNDEAD_ARMY_MANAGER != null).addCondition(data -> data.attacker instanceof Player && !UndeadArmyManager.isUndeadArmy(data.target)).addCondition(data -> UndeadArmyConfig.getRequiredKills() > 0);
        OnServerTickContext onServerTick = new OnServerTickContext(this::tickManager);
        onServerTick.addCondition(data -> ((TickEvent.ServerTickEvent)data.event).phase == TickEvent.Phase.END && Registries.UNDEAD_ARMY_MANAGER != null);
        this.addContexts(new ContextBase[]{onLoaded, onTick, onArmyProgress, onUndeadKill, onServerTick});
    }

    private void resetUndeadArmyGoals(OnSpawned.Data data) {
        LivingEntity livingEntity;
        UndeadArmy undeadArmy = Registries.UNDEAD_ARMY_MANAGER.findNearestUndeadArmy(data.target.m_20183_());
        if (undeadArmy != null && (livingEntity = data.target) instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            undeadArmy.addUndeadArmyAI(mob);
        }
    }

    private void freezeNearbyWater(OnEntityTickData data) {
        assert (data.entity != null);
        LevelHelper.freezeWater((LivingEntity)data.entity, (double)4.0, (int)30, (int)60, (boolean)false);
    }

    private void updateArmyProgress(OnDeathData data) {
        UndeadArmy undeadArmy = Registries.UNDEAD_ARMY_MANAGER.findNearestUndeadArmy(data.target.m_20183_());
        if (undeadArmy != null) {
            undeadArmy.increaseUndeadCounter();
        }
    }

    private void updateKilledUndead(OnDeathData data) {
        assert (data.attacker != null);
        NBTHelper.IntegerData killedUndeadData = new NBTHelper.IntegerData(data.attacker, "UndeadKilled");
        killedUndeadData.set(kills -> kills + 1);
        if (killedUndeadData.get() >= UndeadArmyConfig.getRequiredKills() && Registries.UNDEAD_ARMY_MANAGER.tryToSpawn((Player)data.attacker)) {
            killedUndeadData.set(Integer.valueOf(0));
        }
    }

    private void tickManager(OnServerTickData data) {
        Registries.UNDEAD_ARMY_MANAGER.tick();
    }
}

