/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy;

import com.mlib.Random;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.config.StringListConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.ForgeConfigSpec;

public class WaveMembersConfig
implements IConfigurable {
    final ConfigGroup group;
    final List<StringListConfig> configs = new ArrayList<StringListConfig>();

    public WaveMembersConfig(String name, String comment) {
        this.group = new ConfigGroup(name, comment, new IConfigurable[0]);
    }

    public String getName() {
        return this.group.getName();
    }

    public String getComment() {
        return this.group.getComment();
    }

    public void build(ForgeConfigSpec.Builder builder) {
        this.group.build(builder);
    }

    public void addWaveConfig(String ... defaultValues) {
        StringListConfig waveConfig = new StringListConfig("wave_" + (this.configs.size() + 1), "", false, defaultValues);
        this.group.addConfig((IConfigurable)waveConfig);
        this.configs.add(waveConfig);
    }

    public List<WaveMember> getWaveMembers(int waveNumber) {
        StringListConfig waveStringConfig = this.configs.get(waveNumber - 1);
        ArrayList<WaveMember> waveMembers = new ArrayList<WaveMember>();
        for (String config : (List)waveStringConfig.get()) {
            Optional optionalEntityType;
            Pattern pattern = Pattern.compile("(.*)-(.*) (.*)");
            Matcher matcher = pattern.matcher(config);
            if (!matcher.find() || !(optionalEntityType = EntityType.m_20632_((String)matcher.group(3))).isPresent()) continue;
            int minAmount = Integer.parseInt(matcher.group(1));
            int maxAmount = Integer.parseInt(matcher.group(2));
            WaveMember waveMember = new WaveMember(Random.nextInt((int)minAmount, (int)(maxAmount + 1)), (EntityType)optionalEntityType.get());
            if (waveMember.amount <= 0) continue;
            waveMembers.add(waveMember);
        }
        return waveMembers;
    }

    public record WaveMember(int amount, EntityType<?> entityType) {
    }
}

