/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.config;

import com.mlib.config.IConfigurable;

public abstract class UserConfig
implements IConfigurable {
    protected final String name;
    protected final String comment;
    protected final boolean worldRestartRequired;

    public UserConfig(String name, String comment, boolean worldRestartRequired) {
        this.name = name;
        this.comment = UserConfig.validateComment(comment, worldRestartRequired);
        this.worldRestartRequired = worldRestartRequired;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean requiresWorldRestart() {
        return this.worldRestartRequired;
    }

    private static String validateComment(String comment, boolean requiresWorldRestart) {
        if (!comment.isEmpty() && requiresWorldRestart) {
            if (comment.endsWith(".")) {
                return comment.substring(0, comment.length() - 1) + " (requires world/game restart).";
            }
            return comment + " (requires world/game restart)";
        }
        return comment;
    }
}

