/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.events;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.IModBusEvent;

@Mod.EventBusSubscriber
public class ExplosionSizeEvent
extends Event
implements IModBusEvent {
    public final Level level;
    public final Explosion explosion;
    public float size;
    public boolean causesFire;

    public ExplosionSizeEvent(Level level, Explosion explosion) {
        this.level = level;
        this.explosion = explosion;
        this.size = this.explosion.f_46017_;
        this.causesFire = this.explosion.f_46009_;
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Start explosionEvent) {
        Level level = explosionEvent.getLevel();
        Explosion explosion = explosionEvent.getExplosion();
        ExplosionSizeEvent event = new ExplosionSizeEvent(level, explosion);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if ((double)(event.size / explosion.f_46017_) > 1.25 && level instanceof ServerLevel) {
            ExplosionSizeEvent.sendToPlayers((ServerLevel)level, explosion, explosion.getPosition(), event.size);
        }
        explosion.f_46017_ = event.size;
        explosion.f_46009_ = event.causesFire;
    }

    private static void sendToPlayers(ServerLevel level, Explosion explosion, Vec3 position, float size) {
        double x = position.f_82479_;
        double y = position.f_82480_;
        double z = position.f_82481_;
        for (ServerPlayer player : level.m_6907_()) {
            if (!(player.m_20275_(x, y, z) < 4096.0)) continue;
            player.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(x, y, z, size, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(player)));
        }
    }
}

