/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.gamemodifiers;

import com.mlib.MajruszLibrary;
import com.mlib.Registries;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.gamemodifiers.ContextBase;
import com.mlib.gamemodifiers.ContextData;
import java.util.ArrayList;
import java.util.List;

public abstract class GameModifier
extends ConfigGroup {
    public static final String DEFAULT_KEY = Registries.getLocationString("default");
    final List<ContextBase<? extends ContextData>> contexts = new ArrayList<ContextBase<? extends ContextData>>();
    final String configKey;

    public static ConfigGroup addNewGroup(String key, String name, String comment) {
        ConfigGroup group = new ConfigGroup(name, comment, new IConfigurable[0]);
        MajruszLibrary.MOD_CONFIGS.setup(key, group);
        return group;
    }

    public static ConfigGroup addNewGroup(String key) {
        return GameModifier.addNewGroup(key, "GameModifiers", "");
    }

    public GameModifier(String configKey, String configName, String configComment) {
        super(configName, configComment, new IConfigurable[0]);
        this.configKey = configKey;
        MajruszLibrary.MOD_CONFIGS.insert(configKey, this);
    }

    public GameModifier(String configName, String configComment) {
        this(DEFAULT_KEY, configName, configComment);
    }

    public <DataType extends ContextData> void addContext(ContextBase<DataType> context) {
        context.setup(this);
        this.addConfig(context);
    }

    public void addContexts(ContextBase<?> ... contexts) {
        for (ContextBase<?> context : contexts) {
            this.addContext(context);
        }
    }

    public List<ContextBase<? extends ContextData>> getContexts() {
        return this.contexts;
    }

    public String getConfigKey() {
        return this.configKey;
    }
}

