/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.gamemodifiers.contexts;

import com.mlib.gamemodifiers.ContextBase;
import com.mlib.gamemodifiers.data.OnExplosionData;
import com.mlib.gamemodifiers.parameters.ContextParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class OnExplosionContext
extends ContextBase<OnExplosionData> {
    static final List<OnExplosionContext> CONTEXTS = Collections.synchronizedList(new ArrayList());

    public OnExplosionContext(Consumer<OnExplosionData> consumer, ContextParameters params) {
        super(OnExplosionData.class, consumer, params);
        ContextBase.addSorted(CONTEXTS, this);
    }

    public OnExplosionContext(Consumer<OnExplosionData> consumer) {
        this(consumer, new ContextParameters());
    }

    @SubscribeEvent
    public static void onExplosionStart(ExplosionEvent.Start event) {
        OnExplosionData data = new OnExplosionData((ExplosionEvent)event);
        ContextBase.accept(CONTEXTS, data);
        OnExplosionContext.updateEvent(data);
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        ContextBase.accept(CONTEXTS, new OnExplosionData((ExplosionEvent)event));
    }

    private static void updateEvent(OnExplosionData data) {
        if ((double)(data.radius.getValue().floatValue() - data.explosion.f_46017_) < 1.0 || data.level == null) {
            return;
        }
        data.explosion.f_46017_ = data.radius.getValue().floatValue();
        data.explosion.f_46009_ = data.causesFire.getValue();
        double x = data.explosion.getPosition().f_82479_;
        double y = data.explosion.getPosition().f_82480_;
        double z = data.explosion.getPosition().f_82481_;
        for (ServerPlayer player : data.level.m_6907_()) {
            if (!(player.m_20275_(x, y, z) < 4096.0)) continue;
            player.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(x, y, z, data.explosion.f_46017_, data.explosion.m_46081_(), (Vec3)data.explosion.m_46078_().get(player)));
        }
    }
}

