/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.gamemodifiers.contexts;

import com.mlib.gamemodifiers.ContextBase;
import com.mlib.gamemodifiers.ContextData;
import com.mlib.gamemodifiers.parameters.ContextParameters;
import com.mlib.time.Delay;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class OnSpawned {
    public static final Predicate<Data> IS_NOT_LOADED_FROM_DISK = data -> !data.loadedFromDisk;

    public static class Data
    extends ContextData {
        public final LivingEntity target;
        public final boolean loadedFromDisk;

        public Data(LivingEntity target, boolean loadedFromDisk) {
            super(target);
            this.target = target;
            this.loadedFromDisk = loadedFromDisk;
        }
    }

    @Mod.EventBusSubscriber
    public static class Context
    extends ContextBase<Data> {
        static final List<Context> CONTEXTS = Collections.synchronizedList(new ArrayList());

        public Context(Consumer<Data> consumer, ContextParameters params) {
            super(Data.class, consumer, params);
            ContextBase.addSorted(CONTEXTS, this);
        }

        public Context(Consumer<Data> consumer) {
            this(consumer, new ContextParameters());
        }

        @SubscribeEvent
        public static void onSpawn(EntityJoinLevelEvent event) {
            LivingEntity entity;
            block3: {
                block2: {
                    Entity entity2 = event.getEntity();
                    if (!(entity2 instanceof LivingEntity)) break block2;
                    entity = (LivingEntity)entity2;
                    if (event.getLevel() instanceof ServerLevel) break block3;
                }
                return;
            }
            Delay.onNextTick(() -> ContextBase.accept(CONTEXTS, new Data(entity, event.loadedFromDisk())));
        }
    }
}

