/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.network.message;

import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class BaseMessage {
    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender != null) {
                this.receiveMessage(sender, context);
            } else {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.receiveMessage(context));
            }
        });
        context.setPacketHandled(true);
    }

    public void receiveMessage(ServerPlayer sender, NetworkEvent.Context context) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void receiveMessage(NetworkEvent.Context context) {
    }
}

