/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moyai;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="moyai", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientStuff {

    public static class MoyaiHeadLayer<T extends LivingEntity, M extends SegmentedModel<T>>
    extends LayerRenderer<T, M> {
        ModelRenderer head = null;

        public MoyaiHeadLayer(IEntityRenderer<T, M> renderer) {
            super(renderer);
            if (renderer.func_217764_d() instanceof IHasHead) {
                this.head = ((IHasHead)renderer.func_217764_d()).func_205072_a();
            }
        }

        public void render(MatrixStack pMatrixStack, IRenderTypeBuffer pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            ItemStack itemstack = pLivingEntity.func_184582_a(EquipmentSlotType.HEAD);
            if (!itemstack.func_190926_b() && this.head != null) {
                pMatrixStack.func_227860_a_();
                this.head.func_228307_a_(pMatrixStack);
                MoyaiHeadLayer.translateToHead(pMatrixStack, false);
                Minecraft.func_71410_x().func_175597_ag().func_228397_a_(pLivingEntity, itemstack, ItemCameraTransforms.TransformType.HEAD, false, pMatrixStack, pBuffer, pPackedLight);
                pMatrixStack.func_227865_b_();
            }
        }

        public static void translateToHead(MatrixStack stack, boolean p_174485_) {
            float f = 0.625f;
            stack.func_227861_a_(0.0, -0.25, 0.0);
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            stack.func_227862_a_(0.625f, -0.625f, -0.625f);
            stack.func_227861_a_(0.0, 0.296875, -0.125);
        }
    }

    @Mod.EventBusSubscriber(modid="moyai", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Rumbler {
        private static final int SHAKE_DURATION = 40;
        private static final int MAX_DIST = 16;
        private static final Map<BlockPos, Float> CACHED_POS = new HashMap<BlockPos, Float>();
        private static float animationCounter = 0.0f;

        public static void setShaking(BlockPos pos, int note) {
            float n = 1.0f - (float)note / 24.0f;
            ClientPlayerEntity p = Minecraft.func_71410_x().field_71439_g;
            if (p != null) {
                CACHED_POS.put(pos, Float.valueOf(40.0f * (0.75f * (n - 0.5f) + 1.0f)));
            }
        }

        private static double getIntensity(BlockPos pos, PlayerEntity player) {
            double dist = player.func_213303_ch().func_186679_c((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            return Math.max(0.0, 256.0 - dist) / 256.0;
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                animationCounter += 1.0f;
            }
        }

        @SubscribeEvent
        public static void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
            ClientPlayerEntity p = Minecraft.func_71410_x().field_71439_g;
            if (p != null && !Minecraft.func_71410_x().func_147113_T()) {
                double maxIntensity = 0.0;
                HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
                for (BlockPos pos : CACHED_POS.keySet()) {
                    maxIntensity = Math.max(maxIntensity, Rumbler.getIntensity(pos, (PlayerEntity)p));
                    float duration = CACHED_POS.get(pos).floatValue();
                    if ((duration = (float)((double)duration - event.getRenderPartialTicks())) < 0.0f) {
                        toRemove.add(pos);
                        continue;
                    }
                    CACHED_POS.put(pos, Float.valueOf(duration));
                }
                toRemove.forEach(CACHED_POS::remove);
                if (maxIntensity != 0.0) {
                    event.setRoll((float)((double)event.getRoll() + (double)(MathHelper.func_76126_a((float)((float)(((double)animationCounter + event.getRenderPartialTicks()) / 3.0 % 1.0 * 2.0 * Math.PI))) * 1.5f) * maxIntensity));
                }
            }
        }
    }
}

