/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moyai;

import java.util.Set;
import net.mehvahdjukaar.moyai.ConfiguredFeaturesRegistry;
import net.mehvahdjukaar.moyai.MoyaiBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.NoteBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Rarity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.NoteBlockInstrument;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="moyai")
public class Moyai {
    public static final String MOD_ID = "moyai";
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"moyai");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"moyai");
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"moyai");
    public static final RegistryObject<SoundEvent> MOYAI_BOOM = SOUNDS.register("moyai_boom", () -> new SoundEvent(Moyai.res("record.moyai_boom")));
    public static final RegistryObject<SoundEvent> MOYAI_ROTATE = SOUNDS.register("moyai_rotate", () -> new SoundEvent(Moyai.res("block.moyai_rotate")));
    public static final RegistryObject<Block> MOYAI = BLOCKS.register("moyai", MoyaiBlock::new);
    public static final RegistryObject<BlockItem> MOYAI_ITEM = ITEMS.register("moyai", () -> new BlockItem((Block)MOYAI.get(), new Item.Properties().func_208103_a(Rarity.RARE).func_200916_a(ItemGroup.field_78030_b)));

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public Moyai() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(bus);
        ITEMS.register(bus);
        SOUNDS.register(bus);
        bus.addListener(ConfiguredFeaturesRegistry::registerFeatures);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void addStuffToBiomes(BiomeLoadingEvent event) {
        RegistryKey key;
        Set types;
        ResourceLocation res;
        Biome.Category category = event.getCategory();
        if (category != Biome.Category.NETHER && category != Biome.Category.THEEND && category != Biome.Category.NONE && (res = event.getName()) != null && category != Biome.Category.ICY && !(types = BiomeDictionary.getTypes((RegistryKey)(key = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)res)))).contains(BiomeDictionary.Type.SNOWY)) {
            if (category == Biome.Category.MUSHROOM) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeaturesRegistry.MUSHROOM_MOYAI_PATCH);
            } else if (category == Biome.Category.BEACH) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeaturesRegistry.BEACH_MOYAI_PATCH);
            }
        }
    }

    @SubscribeEvent
    public void onNotePlayed(NoteBlockEvent.Play event) {
        BlockPos pos;
        IWorld level;
        BlockState below;
        if (event.getInstrument() == NoteBlockInstrument.BASEDRUM && (below = (level = event.getWorld()).func_180495_p((pos = event.getPos()).func_177977_b())).func_177230_c() instanceof MoyaiBlock && level instanceof ServerWorld) {
            event.setCanceled(true);
            int i = (Integer)event.getState().func_177229_b((Property)NoteBlock.field_196485_c);
            float f = (float)Math.pow(2.0, (double)(i - 12) / 12.0);
            level.func_184133_a(null, pos, (SoundEvent)MOYAI_BOOM.get(), SoundCategory.RECORDS, 0.5f, f);
            ((ServerWorld)level).func_175641_c(pos.func_177977_b(), below.func_177230_c(), 0, i);
        }
    }
}

