/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moyai;

import java.util.Locale;
import java.util.Random;
import java.util.function.Predicate;
import net.mehvahdjukaar.moyai.ClientStuff;
import net.mehvahdjukaar.moyai.Moyai;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.pattern.BlockMaterialMatcher;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.block.pattern.BlockPatternBuilder;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

public class MoyaiBlock
extends FallingBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final EnumProperty<RotationMode> MODE = EnumProperty.func_177709_a((String)"mode", RotationMode.class);
    private static long LAST_GREETED_TIME = -24000L;
    @javax.annotation.Nullable
    private BlockPattern ironGolemBase;
    @javax.annotation.Nullable
    private BlockPattern ironGolemFull;

    protected MoyaiBlock() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_235337_cO_).func_200944_c().func_200948_a(5.0f, 4.0f));
        this.func_176223_P().func_206870_a(MODE, (Comparable)((Object)RotationMode.STATIC));
    }

    public BlockState func_185499_a(BlockState pState, Rotation pRot) {
        return (BlockState)pState.func_206870_a((Property)FACING, (Comparable)pRot.func_185831_a((Direction)pState.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState pState, Mirror pMirror) {
        return pState.func_185907_a(pMirror.func_185800_a((Direction)pState.func_177229_b((Property)FACING)));
    }

    public BlockState func_196258_a(BlockItemUseContext pContext) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(MODE, (Comparable)((Object)RotationMode.STATIC))).func_206870_a((Property)FACING, (Comparable)pContext.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> pBuilder) {
        super.func_206840_a(pBuilder);
        pBuilder.func_206894_a(new Property[]{FACING});
        pBuilder.func_206894_a(new Property[]{MODE});
    }

    public ActionResultType func_225533_a_(BlockState pState, World pLevel, BlockPos pPos, PlayerEntity pPlayer, Hand pHand, BlockRayTraceResult pHit) {
        long time;
        if (pLevel.field_72995_K && Math.abs((time = pLevel.func_72820_D()) - LAST_GREETED_TIME) >= 12000L) {
            LAST_GREETED_TIME = time;
            pPlayer.func_146105_b((ITextComponent)new TranslationTextComponent("message.moyai.angelo"), true);
            pPlayer.func_184609_a(pHand);
        }
        return super.func_225533_a_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public boolean func_196260_a(BlockState state, IWorldReader level, BlockPos pos) {
        if (level instanceof WorldGenRegion) {
            Direction direction = (Direction)state.func_177229_b((Property)FACING);
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockState s = level.func_180495_p(pos.func_177972_a(dir));
                if (dir == direction && !s.func_196958_f()) {
                    return false;
                }
                if (!s.func_203425_a((Block)this) || s.func_177229_b((Property)FACING) != dir.func_176734_d()) continue;
                return false;
            }
        }
        return true;
    }

    public int func_189876_x(BlockState pState, IBlockReader pReader, BlockPos pPos) {
        return pState.func_185909_g((IBlockReader)pReader, (BlockPos)pPos).field_76291_p;
    }

    protected void func_149829_a(FallingBlockEntity pFallingEntity) {
        pFallingEntity.func_145806_a(true);
    }

    public void func_176502_a_(World level, BlockPos pos, BlockState p_48795_, BlockState state, FallingBlockEntity blockEntity) {
        if (!blockEntity.func_174814_R()) {
            level.func_217379_c(1045, pos, 0);
            this.trySpawnGolem(level, pos, false);
        }
    }

    public void func_180633_a(World pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.func_180633_a(pLevel, pPos, pState, pPlacer, pStack);
        pLevel.func_205220_G_().func_205360_a(pPos, (Object)this, this.func_230329_c_());
    }

    public void func_220082_b(BlockState pState, World pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        boolean golem = false;
        if (!pOldState.func_203425_a(pState.func_177230_c())) {
            golem = this.trySpawnGolem(pLevel, pPos, true);
        }
    }

    public boolean canSpawnGolem(IWorldReader pLevel, BlockPos pPos) {
        return this.getOrCreateIronGolemBase().func_177681_a(pLevel, pPos) != null;
    }

    private boolean trySpawnGolem(World pLevel, BlockPos pPos, boolean playerCreated) {
        BlockPattern pattern = this.getOrCreateIronGolemFull();
        BlockPattern.PatternHelper patternMatch = pattern.func_177681_a((IWorldReader)pLevel, pPos);
        if (patternMatch != null) {
            for (int j = 0; j < pattern.func_177684_c(); ++j) {
                for (int k = 0; k < pattern.func_177685_b(); ++k) {
                    CachedBlockInfo matchBlock = patternMatch.func_177670_a(j, k, 0);
                    pLevel.func_180501_a(matchBlock.func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
                    pLevel.func_217379_c(2001, matchBlock.func_177508_d(), Block.func_196246_j((BlockState)matchBlock.func_177509_a()));
                }
            }
            BlockPos blockpos = patternMatch.func_177670_a(1, 2, 0).func_177508_d();
            IronGolemEntity irongolem = (IronGolemEntity)EntityType.field_200757_aw.func_200721_a(pLevel);
            irongolem.func_70849_f(playerCreated);
            irongolem.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)this));
            irongolem.func_70012_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.05, (double)blockpos.func_177952_p() + 0.5, 0.0f, 0.0f);
            pLevel.func_217376_c((Entity)irongolem);
            for (ServerPlayerEntity player : pLevel.func_217357_a(ServerPlayerEntity.class, irongolem.func_174813_aQ().func_186662_g(5.0))) {
                CriteriaTriggers.field_192133_m.func_192229_a(player, (Entity)irongolem);
            }
            for (int i1 = 0; i1 < pattern.func_177684_c(); ++i1) {
                for (int j1 = 0; j1 < pattern.func_177685_b(); ++j1) {
                    CachedBlockInfo matchBlock = patternMatch.func_177670_a(i1, j1, 0);
                    pLevel.func_230547_a_(matchBlock.func_177508_d(), Blocks.field_150350_a);
                }
            }
            return true;
        }
        return false;
    }

    private BlockPattern getOrCreateIronGolemBase() {
        if (this.ironGolemBase == null) {
            this.ironGolemBase = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"~ ~", "###", "~#~"}).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150339_S))).func_177662_a('~', CachedBlockInfo.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
        }
        return this.ironGolemBase;
    }

    private BlockPattern getOrCreateIronGolemFull() {
        if (this.ironGolemFull == null) {
            this.ironGolemFull = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"~^~", "###", "~#~"}).func_177662_a('^', CachedBlockInfo.func_177510_a(b -> b.func_177230_c() == this)).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150339_S))).func_177662_a('~', CachedBlockInfo.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
        }
        return this.ironGolemFull;
    }

    public boolean func_149653_t(BlockState pState) {
        return pState.func_177229_b(MODE) == RotationMode.STATIC;
    }

    public void func_225542_b_(BlockState pState, ServerWorld pLevel, BlockPos pPos, Random pRandom) {
        if (pLevel.func_230315_m_().func_236035_c_(pLevel.func_241851_ab()) == 0 && pLevel.func_226690_K_()) {
            if (pLevel.field_73012_v.nextBoolean()) {
                pLevel.func_180501_a(pPos, (BlockState)((BlockState)pState.func_206870_a(MODE, (Comparable)((Object)RotationMode.ROTATING_LEFT))).func_206870_a((Property)FACING, (Comparable)((Direction)pState.func_177229_b((Property)FACING)).func_176735_f()), 2);
            } else {
                pLevel.func_180501_a(pPos, (BlockState)((BlockState)pState.func_206870_a(MODE, (Comparable)((Object)RotationMode.ROTATING_RIGHT))).func_206870_a((Property)FACING, (Comparable)((Direction)pState.func_177229_b((Property)FACING)).func_176746_e()), 2);
            }
            pLevel.func_184133_a(null, pPos, (SoundEvent)Moyai.MOYAI_ROTATE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            pLevel.func_205220_G_().func_205360_a(pPos, (Object)this, 40 + pLevel.func_201674_k().nextInt(40));
        }
        super.func_225542_b_(pState, pLevel, pPos, pRandom);
    }

    public void func_225534_a_(BlockState pState, ServerWorld pLevel, BlockPos pPos, Random pRand) {
        RotationMode mode = (RotationMode)((Object)pState.func_177229_b(MODE));
        if (mode != RotationMode.STATIC) {
            if (mode == RotationMode.ROTATING_RIGHT) {
                pLevel.func_175656_a(pPos, (BlockState)((BlockState)pState.func_206870_a(MODE, (Comparable)((Object)RotationMode.STATIC))).func_206870_a((Property)FACING, (Comparable)((Direction)pState.func_177229_b((Property)FACING)).func_176735_f()));
            } else {
                pLevel.func_175656_a(pPos, (BlockState)((BlockState)pState.func_206870_a(MODE, (Comparable)((Object)RotationMode.STATIC))).func_206870_a((Property)FACING, (Comparable)((Direction)pState.func_177229_b((Property)FACING)).func_176746_e()));
            }
            pLevel.func_184133_a(null, pPos, (SoundEvent)Moyai.MOYAI_ROTATE.get(), SoundCategory.BLOCKS, 1.0f, 0.8f);
        }
        super.func_225534_a_(pState, pLevel, pPos, pRand);
    }

    public boolean func_189539_a(BlockState pState, World pLevel, BlockPos pPos, int pId, int pParam) {
        if (pId == 0) {
            pLevel.func_195594_a((IParticleData)ParticleTypes.field_197597_H, (double)pPos.func_177958_n() + 0.5, (double)pPos.func_177956_o() + 1.2 + 1.0, (double)pPos.func_177952_p() + 0.5, (double)pParam / 24.0, 0.0, 0.0);
            if (pLevel.field_72995_K) {
                ClientStuff.Rumbler.setShaking(pPos, pParam);
            }
            return true;
        }
        return super.func_189539_a(pState, pLevel, pPos, pId, pParam);
    }

    private static enum RotationMode implements IStringSerializable
    {
        ROTATING_LEFT,
        ROTATING_RIGHT,
        STATIC;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

