/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moyai;

import java.util.Locale;
import java.util.Random;
import java.util.function.Predicate;
import net.mehvahdjukaar.moyai.ClientStuff;
import net.mehvahdjukaar.moyai.Moyai;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockMaterialPredicate;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class MoyaiBlock
extends FallingBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<RotationMode> MODE = EnumProperty.m_61587_((String)"mode", RotationMode.class);
    private static long LAST_GREETED_TIME = -24000L;
    @javax.annotation.Nullable
    private BlockPattern ironGolemBase;
    @javax.annotation.Nullable
    private BlockPattern ironGolemFull;

    protected MoyaiBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50137_).m_60977_().m_60913_(5.0f, 4.0f));
        this.m_49966_().m_61124_(MODE, (Comparable)((Object)RotationMode.STATIC));
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_(MODE, (Comparable)((Object)RotationMode.STATIC))).m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING});
        pBuilder.m_61104_(new Property[]{MODE});
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        long time;
        if (pLevel.f_46443_ && Math.abs((time = pLevel.m_46468_()) - LAST_GREETED_TIME) >= 12000L) {
            LAST_GREETED_TIME = time;
            pPlayer.m_5661_((Component)new TranslatableComponent("message.moyai.angelo"), true);
            pPlayer.m_6674_(pHand);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (level instanceof WorldGenRegion) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockState s = level.m_8055_(pos.m_142300_(dir));
                if (dir == direction && !s.m_60795_()) {
                    return false;
                }
                if (!s.m_60713_((Block)this) || s.m_61143_((Property)FACING) != dir.m_122424_()) continue;
                return false;
            }
        }
        return true;
    }

    public int m_6248_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return pState.m_60780_((BlockGetter)pReader, (BlockPos)pPos).f_76396_;
    }

    protected void m_6788_(FallingBlockEntity pFallingEntity) {
        pFallingEntity.m_149656_(2.0f, 40);
    }

    public void m_142216_(Level level, BlockPos pos, BlockState p_48795_, BlockState state, FallingBlockEntity blockEntity) {
        if (!blockEntity.m_20067_()) {
            level.m_46796_(1045, pos, 0);
            this.trySpawnGolem(level, pos, false);
        }
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        pLevel.m_186460_(pPos, (Block)this, this.m_7198_());
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        boolean golem = false;
        if (!pOldState.m_60713_(pState.m_60734_())) {
            golem = this.trySpawnGolem(pLevel, pPos, true);
        }
    }

    public boolean canSpawnGolem(LevelReader pLevel, BlockPos pPos) {
        return this.getOrCreateIronGolemBase().m_61184_(pLevel, pPos) != null;
    }

    private boolean trySpawnGolem(Level pLevel, BlockPos pPos, boolean playerCreated) {
        BlockPattern pattern = this.getOrCreateIronGolemFull();
        BlockPattern.BlockPatternMatch patternMatch = pattern.m_61184_((LevelReader)pLevel, pPos);
        if (patternMatch != null) {
            for (int j = 0; j < pattern.m_61203_(); ++j) {
                for (int k = 0; k < pattern.m_61202_(); ++k) {
                    BlockInWorld matchBlock = patternMatch.m_61229_(j, k, 0);
                    pLevel.m_7731_(matchBlock.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                    pLevel.m_46796_(2001, matchBlock.m_61176_(), Block.m_49956_((BlockState)matchBlock.m_61168_()));
                }
            }
            BlockPos blockpos = patternMatch.m_61229_(1, 2, 0).m_61176_();
            IronGolem irongolem = (IronGolem)EntityType.f_20460_.m_20615_(pLevel);
            irongolem.m_28887_(playerCreated);
            irongolem.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)this));
            irongolem.m_7678_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.05, (double)blockpos.m_123343_() + 0.5, 0.0f, 0.0f);
            pLevel.m_7967_((Entity)irongolem);
            for (ServerPlayer player : pLevel.m_45976_(ServerPlayer.class, irongolem.m_142469_().m_82400_(5.0))) {
                CriteriaTriggers.f_10580_.m_68256_(player, (Entity)irongolem);
            }
            for (int i1 = 0; i1 < pattern.m_61203_(); ++i1) {
                for (int j1 = 0; j1 < pattern.m_61202_(); ++j1) {
                    BlockInWorld matchBlock = patternMatch.m_61229_(i1, j1, 0);
                    pLevel.m_6289_(matchBlock.m_61176_(), Blocks.f_50016_);
                }
            }
            return true;
        }
        return false;
    }

    private BlockPattern getOrCreateIronGolemBase() {
        if (this.ironGolemBase == null) {
            this.ironGolemBase = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~ ~", "###", "~#~"}).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50075_))).m_61244_('~', BlockInWorld.m_61169_((Predicate)BlockMaterialPredicate.m_61262_((Material)Material.f_76296_))).m_61249_();
        }
        return this.ironGolemBase;
    }

    private BlockPattern getOrCreateIronGolemFull() {
        if (this.ironGolemFull == null) {
            this.ironGolemFull = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~^~", "###", "~#~"}).m_61244_('^', BlockInWorld.m_61169_(b -> b.m_60734_() == this)).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50075_))).m_61244_('~', BlockInWorld.m_61169_((Predicate)BlockMaterialPredicate.m_61262_((Material)Material.f_76296_))).m_61249_();
        }
        return this.ironGolemFull;
    }

    public boolean m_6724_(BlockState pState) {
        return pState.m_61143_(MODE) == RotationMode.STATIC;
    }

    public void m_7455_(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRandom) {
        if (pLevel.m_46941_() == 0 && pLevel.m_46462_()) {
            if (pLevel.f_46441_.nextBoolean()) {
                pLevel.m_7731_(pPos, (BlockState)((BlockState)pState.m_61124_(MODE, (Comparable)((Object)RotationMode.ROTATING_LEFT))).m_61124_((Property)FACING, (Comparable)((Direction)pState.m_61143_((Property)FACING)).m_122428_()), 2);
            } else {
                pLevel.m_7731_(pPos, (BlockState)((BlockState)pState.m_61124_(MODE, (Comparable)((Object)RotationMode.ROTATING_RIGHT))).m_61124_((Property)FACING, (Comparable)((Direction)pState.m_61143_((Property)FACING)).m_122427_()), 2);
            }
            pLevel.m_5594_(null, pPos, (SoundEvent)Moyai.MOYAI_ROTATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            pLevel.m_186460_(pPos, (Block)this, 40 + pLevel.m_5822_().nextInt(40));
        }
        super.m_7455_(pState, pLevel, pPos, pRandom);
    }

    public void m_7458_(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRand) {
        RotationMode mode = (RotationMode)((Object)pState.m_61143_(MODE));
        if (mode != RotationMode.STATIC) {
            if (mode == RotationMode.ROTATING_RIGHT) {
                pLevel.m_46597_(pPos, (BlockState)((BlockState)pState.m_61124_(MODE, (Comparable)((Object)RotationMode.STATIC))).m_61124_((Property)FACING, (Comparable)((Direction)pState.m_61143_((Property)FACING)).m_122428_()));
            } else {
                pLevel.m_46597_(pPos, (BlockState)((BlockState)pState.m_61124_(MODE, (Comparable)((Object)RotationMode.STATIC))).m_61124_((Property)FACING, (Comparable)((Direction)pState.m_61143_((Property)FACING)).m_122427_()));
            }
            pLevel.m_5594_(null, pPos, (SoundEvent)Moyai.MOYAI_ROTATE.get(), SoundSource.BLOCKS, 1.0f, 0.8f);
        }
        super.m_7458_(pState, pLevel, pPos, pRand);
    }

    public boolean m_8133_(BlockState pState, Level pLevel, BlockPos pPos, int pId, int pParam) {
        if (pId == 0) {
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 1.2 + 1.0, (double)pPos.m_123343_() + 0.5, (double)pParam / 24.0, 0.0, 0.0);
            if (pLevel.f_46443_) {
                ClientStuff.Rumbler.setShaking(pPos, pParam);
            }
            return true;
        }
        return super.m_8133_(pState, pLevel, pPos, pId, pParam);
    }

    private static enum RotationMode implements StringRepresentable
    {
        ROTATING_LEFT,
        ROTATING_RIGHT,
        STATIC;


        public String toString() {
            return this.m_7912_();
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

