/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moyai;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="moyai", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientStuff {
    @SubscribeEvent
    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        ClientStuff.addLayer(event.getRenderer(EntityType.f_20460_));
    }

    private static <T extends LivingEntity, M extends HierarchicalModel<T>, R extends LivingEntityRenderer<T, M>> void addLayer(@Nullable R renderer) {
        if (renderer != null) {
            renderer.m_115326_(new MoyaiHeadLayer(renderer));
        }
    }

    public static class MoyaiHeadLayer<T extends LivingEntity, M extends HierarchicalModel<T>>
    extends RenderLayer<T, M> {
        private final ModelPart head;
        private final ItemInHandRenderer itemRenderer = Minecraft.m_91087_().m_91290_().m_234586_();

        public MoyaiHeadLayer(RenderLayerParent<T, M> parent) {
            super(parent);
            this.head = ((HierarchicalModel)this.m_117386_()).m_142109_().m_171324_("head");
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            ItemStack itemstack = pLivingEntity.m_6844_(EquipmentSlot.HEAD);
            if (!itemstack.m_41619_()) {
                pMatrixStack.m_85836_();
                this.head.m_104299_(pMatrixStack);
                MoyaiHeadLayer.translateToHead(pMatrixStack, false);
                this.itemRenderer.m_109322_(pLivingEntity, itemstack, ItemTransforms.TransformType.HEAD, false, pMatrixStack, pBuffer, pPackedLight);
                pMatrixStack.m_85849_();
            }
        }

        public static void translateToHead(PoseStack stack, boolean p_174485_) {
            float f = 0.625f;
            stack.m_85837_(0.0, -0.25, 0.0);
            stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            stack.m_85841_(0.625f, -0.625f, -0.625f);
            stack.m_85837_(0.0, 0.296875, -0.125);
        }
    }

    @Mod.EventBusSubscriber(modid="moyai", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Rumbler {
        private static final int SHAKE_DURATION = 40;
        private static final int MAX_DIST = 16;
        private static final Map<BlockPos, Float> CACHED_POS = new HashMap<BlockPos, Float>();
        private static float animationCounter = 0.0f;

        public static void setShaking(BlockPos pos, int note) {
            float n = 1.0f - (float)note / 24.0f;
            LocalPlayer p = Minecraft.m_91087_().f_91074_;
            if (p != null) {
                CACHED_POS.put(pos, Float.valueOf(40.0f * (0.75f * (n - 0.5f) + 1.0f)));
            }
        }

        private static double getIntensity(BlockPos pos, Player player) {
            double dist = player.m_20182_().m_82531_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            return Math.max(0.0, 256.0 - dist) / 256.0;
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                animationCounter += 1.0f;
            }
        }

        @SubscribeEvent
        public static void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
            LocalPlayer p = Minecraft.m_91087_().f_91074_;
            if (p != null && !Minecraft.m_91087_().m_91104_()) {
                double maxIntensity = 0.0;
                HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
                for (BlockPos pos : CACHED_POS.keySet()) {
                    maxIntensity = Math.max(maxIntensity, Rumbler.getIntensity(pos, (Player)p));
                    float duration = CACHED_POS.get(pos).floatValue();
                    if ((duration = (float)((double)duration - event.getPartialTick())) < 0.0f) {
                        toRemove.add(pos);
                        continue;
                    }
                    CACHED_POS.put(pos, Float.valueOf(duration));
                }
                toRemove.forEach(CACHED_POS::remove);
                if (maxIntensity != 0.0) {
                    event.setRoll((float)((double)event.getRoll() + (double)(Mth.m_14031_((float)((float)(((double)animationCounter + event.getPartialTick()) / 3.0 % 1.0 * 2.0 * Math.PI))) * 1.5f) * maxIntensity));
                }
            }
        }
    }
}

