/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moyai;

import net.mehvahdjukaar.moyai.ConfiguredFeaturesRegistry;
import net.mehvahdjukaar.moyai.MoyaiBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="moyai")
public class Moyai {
    public static final String MOD_ID = "moyai";
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"moyai");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"moyai");
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"moyai");
    public static final RegistryObject<SoundEvent> MOYAI_BOOM_SOUND = SOUNDS.register("moyai_boom", () -> new SoundEvent(Moyai.res("record.moyai_boom")));
    public static final RegistryObject<SoundEvent> MOYAI_ROTATE = SOUNDS.register("moyai_rotate", () -> new SoundEvent(Moyai.res("block.moyai_rotate")));
    public static final RegistryObject<Block> MOYAI = BLOCKS.register("moyai", MoyaiBlock::new);
    public static final RegistryObject<BlockItem> MOYAI_ITEM = ITEMS.register("moyai", () -> new BlockItem((Block)MOYAI.get(), new Item.Properties().m_41497_(Rarity.RARE).m_41491_(CreativeModeTab.f_40749_)));
    public static GameEvent MOYAI_BOOM_EVENT = null;

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public Moyai() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(bus);
        ITEMS.register(bus);
        SOUNDS.register(bus);
        bus.addListener(ConfiguredFeaturesRegistry::registerFeatures);
        bus.addListener(Moyai::init);
        bus.addListener(Moyai::registerAdditionalStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void registerAdditionalStuff(RegisterEvent event) {
        if (event.getRegistryKey() == ForgeRegistries.ITEMS.getRegistryKey()) {
            MOYAI_BOOM_EVENT = (GameEvent)Registry.m_122965_((Registry)Registry.f_175412_, (ResourceLocation)Moyai.res("moyai_boom"), (Object)new GameEvent("moyai_boom", 16));
        }
    }

    public static void init(FMLCommonSetupEvent event) {
        Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("supplementaries:soap"));
        if (i != Items.f_41852_ && i != null) {
            DispenserBlock.m_52672_((ItemLike)i, (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

                protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                    BlockPos pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                    BlockState state = source.m_7727_().m_8055_(pos);
                    if (state.m_60713_((Block)MOYAI.get()) && MoyaiBlock.maybeEatSoap(stack, state, pos, (Level)source.m_7727_(), null)) {
                        return stack;
                    }
                    return super.m_7498_(source, stack);
                }
            });
        }
    }

    @SubscribeEvent
    public void onNotePlayed(NoteBlockEvent.Play event) {
        BlockPos pos;
        LevelAccessor level;
        BlockState below;
        if (event.getInstrument() == NoteBlockInstrument.BASEDRUM && (below = (level = event.getWorld()).m_8055_((pos = event.getPos()).m_7495_())).m_60734_() instanceof MoyaiBlock && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            level.m_142346_(null, MOYAI_BOOM_EVENT, pos);
            event.setCanceled(true);
            int i = (Integer)event.getState().m_61143_((Property)NoteBlock.f_55013_);
            float f = (float)Math.pow(2.0, (double)(i - 12) / 12.0);
            level.m_5594_(null, pos, (SoundEvent)MOYAI_BOOM_SOUND.get(), SoundSource.RECORDS, 0.5f, f);
            serverLevel.m_7696_(pos.m_7495_(), below.m_60734_(), 0, i);
        }
    }
}

