/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.model.forge;

import com.google.common.base.Preconditions;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;

public class BakedQuadBuilderImpl
implements BakedQuadBuilder {
    private final QuadBakingVertexConsumer inner = new QuadBakingVertexConsumer(s -> {
        this.output = s;
    });
    private BakedQuad output;
    private Matrix4f transform = null;

    public static BakedQuadBuilder create() {
        return new BakedQuadBuilderImpl();
    }

    private BakedQuadBuilderImpl() {
    }

    @Override
    public BakedQuadBuilder setSprite(TextureAtlasSprite sprite) {
        this.inner.setSprite(sprite);
        return null;
    }

    @Override
    public BakedQuadBuilder setDirection(Direction direction) {
        if (this.transform != null) {
            Vec3i normal = direction.m_122436_();
            Vector3f v = BakedQuadBuilder.applyModelRotation(normal.m_123341_(), normal.m_123342_(), normal.m_123343_(), this.transform);
            this.inner.setDirection(Direction.m_122372_((float)v.m_122239_(), (float)v.m_122260_(), (float)v.m_122269_()));
            return this;
        }
        this.inner.setDirection(direction);
        return this;
    }

    @Override
    public BakedQuadBuilder pos(float x, float y, float z) {
        if (this.transform != null) {
            Vector3f v = BakedQuadBuilder.applyModelRotation(x, y, z, this.transform);
            this.inner.m_5483_((double)v.m_122239_(), (double)v.m_122260_(), (double)v.m_122269_());
            return this;
        }
        this.inner.m_5483_((double)x, (double)y, (double)z);
        return this;
    }

    @Override
    public BakedQuadBuilder normal(float x, float y, float z) {
        if (this.transform != null) {
            Vector3f v = BakedQuadBuilder.applyModelRotation(x, y, z, this.transform);
            this.inner.m_5601_(v.m_122239_(), v.m_122260_(), v.m_122269_());
            return this;
        }
        this.inner.m_5601_(x, y, z);
        return this;
    }

    @Override
    public BakedQuadBuilder color(int rgba) {
        this.inner.m_193479_(rgba);
        return this;
    }

    @Override
    public BakedQuadBuilder uv(float u, float v) {
        this.inner.m_7421_(u, v);
        return this;
    }

    @Override
    public BakedQuadBuilder endVertex() {
        this.inner.m_5752_();
        return this;
    }

    @Override
    public BakedQuad build() {
        Preconditions.checkNotNull((Object)this.output, (Object)"vertex data has not been fully filled");
        return this.output;
    }

    @Override
    public BakedQuadBuilder useTransform(Matrix4f matrix4f) {
        this.transform = matrix4f;
        return this;
    }
}

