/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class FluidContainerList {
    private final Map<Item, Category> emptyToFilledMap = new HashMap<Item, Category>();

    public FluidContainerList() {
    }

    public FluidContainerList(List<Category> categoryList) {
        categoryList.forEach(this::addCategory);
    }

    private void addCategory(Category newCategory) {
        if (!newCategory.isEmpty()) {
            if (this.emptyToFilledMap.containsKey(newCategory.emptyContainer)) {
                Category c = this.emptyToFilledMap.get(newCategory.emptyContainer);
                if (c.containerCapacity == newCategory.containerCapacity) {
                    c.filled.addAll(newCategory.filled);
                }
            } else {
                this.emptyToFilledMap.put(newCategory.emptyContainer, newCategory);
            }
        }
    }

    public Optional<Item> getEmpty(Item filledContainer) {
        for (Map.Entry<Item, Category> e : this.emptyToFilledMap.entrySet()) {
            if (!e.getValue().getFilledItems().contains(filledContainer)) continue;
            return Optional.of(e.getKey());
        }
        return Optional.empty();
    }

    public Optional<Item> getFilled(Item emptyContainer) {
        Category c = this.emptyToFilledMap.get(emptyContainer);
        if (c != null) {
            return c.getFirstFilled();
        }
        return Optional.empty();
    }

    public Optional<Category> getCategoryFromEmpty(Item emptyContainer) {
        return Optional.ofNullable(this.emptyToFilledMap.get(emptyContainer));
    }

    public Optional<Category> getCategoryFromFilled(Item filledContainer) {
        return this.getEmpty(filledContainer).map(this.emptyToFilledMap::get);
    }

    public Optional<List<Category>> encodeList() {
        return this.emptyToFilledMap.isEmpty() ? Optional.empty() : Optional.of(new ArrayList<Category>(this.emptyToFilledMap.values()));
    }

    public Collection<Item> getPossibleFilled() {
        ArrayList<Item> list = new ArrayList<Item>();
        this.emptyToFilledMap.values().forEach(c -> list.addAll(c.filled));
        return list;
    }

    public Collection<Item> getPossibleEmpty() {
        return this.emptyToFilledMap.keySet();
    }

    public Collection<Category> getCategories() {
        return this.emptyToFilledMap.values();
    }

    public void merge(FluidContainerList other) {
        other.emptyToFilledMap.values().forEach(this::addCategory);
    }

    public void add(Item empty, Item filled, int amount) {
        Category c = this.emptyToFilledMap.computeIfAbsent(empty, i -> new Category((Item)i, amount));
        c.addItem(filled);
    }

    public void add(Item empty, Item filled, int amount, SoundEvent fillSound, SoundEvent emptySound) {
        Category c = this.emptyToFilledMap.computeIfAbsent(empty, i -> new Category((Item)i, amount));
        c.addItem(filled);
        c.fillSound = fillSound;
        c.emptySound = emptySound;
    }

    private static <T> Function<Category, Optional<T>> getHackyOptional(Function<Category, T> getter) {
        return f -> {
            Object def;
            Object value = getter.apply((Category)f);
            return value.equals(def = getter.apply(Category.EMPTY)) ? Optional.empty() : Optional.of(value);
        };
    }

    public static class Category {
        private static final Category EMPTY = new Category(Items.f_41852_, 1);
        public static final Codec<Category> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("empty").forGetter(c -> Utils.getID(c.emptyContainer)), (App)Codec.INT.fieldOf("capacity").forGetter(Category::getCapacity), (App)ResourceLocation.f_135803_.listOf().fieldOf("filled").forGetter(c -> c.filled.stream().map(Utils::getID).toList()), (App)Registry.f_122821_.m_194605_().optionalFieldOf("fill_sound").forGetter(FluidContainerList.getHackyOptional(Category::getFillSound)), (App)Registry.f_122821_.m_194605_().optionalFieldOf("empty_sound").forGetter(FluidContainerList.getHackyOptional(Category::getEmptySound))).apply((Applicative)instance, Category::decode));
        private final Item emptyContainer;
        private final int containerCapacity;
        private SoundEvent fillSound;
        private SoundEvent emptySound;
        private final List<Item> filled = new ArrayList<Item>();

        private Category(Item emptyContainer, int capacity, @Nullable SoundEvent fillSound, @Nullable SoundEvent emptySound) {
            this.emptyContainer = emptyContainer;
            this.containerCapacity = capacity;
            this.fillSound = fillSound == null ? SoundEvents.f_11770_ : fillSound;
            this.emptySound = emptySound == null ? SoundEvents.f_11769_ : emptySound;
        }

        private Category(Item emptyContainer, int capacity) {
            this(emptyContainer, capacity, null, null);
        }

        private static Category decode(ResourceLocation empty, int capacity, List<ResourceLocation> filled) {
            return Category.decode(empty, capacity, filled, Optional.empty(), Optional.empty());
        }

        private static Category decode(ResourceLocation empty, int capacity, List<ResourceLocation> filled, Optional<SoundEvent> fillSound, Optional<SoundEvent> emptySound) {
            Optional opt = Registry.f_122827_.m_6612_(empty);
            if (opt.isEmpty()) {
                return EMPTY;
            }
            Category category = new Category((Item)opt.get(), capacity, fillSound.orElse(null), emptySound.orElse(null));
            filled.forEach(f -> {
                if (f.m_135827_().contains("immersiveengineering")) {
                    boolean bl = true;
                }
                Optional opt2 = Registry.f_122827_.m_6612_(f);
                opt2.ifPresent(category::addItem);
            });
            if (category.isEmpty()) {
                return EMPTY;
            }
            return category;
        }

        public Item getEmptyContainer() {
            return this.emptyContainer;
        }

        public int getCapacity() {
            return this.containerCapacity;
        }

        private void addItem(Item i) {
            if (i != Items.f_41852_) {
                this.filled.add(i);
            }
        }

        public int getAmount() {
            return this.containerCapacity;
        }

        public SoundEvent getFillSound() {
            return this.fillSound;
        }

        public SoundEvent getEmptySound() {
            return this.emptySound;
        }

        public List<Item> getFilledItems() {
            return this.filled;
        }

        public boolean isEmpty() {
            return this.filled.isEmpty();
        }

        public Optional<Item> getFirstFilled() {
            return this.filled.stream().findFirst();
        }
    }
}

