/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import dev.architectury.injectables.annotations.ExpectPlatform;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.forge.ISoftFluidTankImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.NotNull;

public interface ISoftFluidTank {
    public static final String POTION_TYPE_KEY = "Bottle";
    public static final int BOTTLE_COUNT = 1;
    public static final int BOWL_COUNT = 2;
    public static final int BUCKET_COUNT = 4;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ISoftFluidTank create(int capacity) {
        return ISoftFluidTankImpl.create(capacity);
    }

    public boolean interactWithPlayer(Player var1, InteractionHand var2, @Nullable Level var3, @Nullable BlockPos var4);

    @Nullable
    public ItemStack interactWithItem(ItemStack var1, @Nullable Level var2, @Nullable BlockPos var3, boolean var4);

    @Nullable
    public ItemStack tryDrainItem(ItemStack var1, @Nullable Level var2, @Nullable BlockPos var3, boolean var4);

    @Nullable
    public ItemStack tryFillingItem(Item var1, @Nullable Level var2, @Nullable BlockPos var3, boolean var4);

    @Nullable
    default public ItemStack tryFillingBottle(Level world, BlockPos pos) {
        return this.tryFillingItem(Items.f_42590_, world, pos, false);
    }

    @Nullable
    default public ItemStack tryFillingBucket(Level world, BlockPos pos) {
        return this.tryFillingItem(Items.f_42446_, world, pos, false);
    }

    @Nullable
    default public ItemStack tryFillingBowl(Level world, BlockPos pos) {
        return this.tryFillingItem(Items.f_42399_, world, pos, false);
    }

    default public boolean isSameFluidAs(SoftFluid other) {
        return this.isSameFluidAs(other, null);
    }

    default public boolean isSameFluidAs(SoftFluid other, @Nullable CompoundTag com) {
        return this.getFluid().equals(other) && ISoftFluidTank.areNbtEquals(this.getNbt(), com);
    }

    public boolean tryAddingFluid(SoftFluid var1, int var2, @Nullable CompoundTag var3);

    default public boolean tryAddingFluid(SoftFluid s, int count) {
        return this.tryAddingFluid(s, count, null);
    }

    default public boolean tryAddingFluid(SoftFluid s) {
        return this.tryAddingFluid(s, 1);
    }

    default public boolean tryTransferFluid(ISoftFluidTank destination) {
        return this.tryTransferFluid(destination, 1);
    }

    public boolean tryTransferFluid(ISoftFluidTank var1, int var2);

    public boolean canRemove(int var1);

    public boolean canAdd(int var1);

    default public boolean canAddSoftFluid(SoftFluid s, int count) {
        return this.canAddSoftFluid(s, count, null);
    }

    default public boolean canAddSoftFluid(SoftFluid s, int count, @Nullable CompoundTag nbt) {
        return this.canAdd(count) && this.isSameFluidAs(s, nbt);
    }

    public boolean isFull();

    public boolean isEmpty();

    public void lossyAdd(int var1);

    public void setCount(int var1);

    public void fillCount();

    public void grow(int var1);

    public void shrink(int var1);

    public float getHeight(float var1);

    public int getComparatorOutput();

    public int getCount();

    @Nonnull
    public SoftFluid getFluid();

    @Nullable
    public CompoundTag getNbt();

    public void setNbt(@Nullable CompoundTag var1);

    public void clear();

    public void copy(ISoftFluidTank var1);

    default public void fill(SoftFluid fluid) {
        this.fill(fluid, null);
    }

    default public void fill(SoftFluid fluid, @Nullable CompoundTag nbt) {
        this.setFluid(fluid, nbt);
        this.fillCount();
    }

    default public void setFluid(@NotNull SoftFluid fluid) {
        this.setFluid(fluid, null);
    }

    public void setFluid(@NotNull SoftFluid var1, @Nullable CompoundTag var2);

    public int getTintColor(@Nullable LevelReader var1, @Nullable BlockPos var2);

    public int getFlowingTint(@Nullable LevelReader var1, @Nullable BlockPos var2);

    public int getParticleColor(@Nullable LevelReader var1, @Nullable BlockPos var2);

    default public boolean containsFood() {
        return this.getFluid().isFood();
    }

    public void load(CompoundTag var1);

    public CompoundTag save(CompoundTag var1);

    public boolean tryDrinkUpFluid(Player var1, Level var2);

    public static boolean areNbtEquals(CompoundTag nbt, CompoundTag nbt1) {
        if ((nbt == null || nbt.m_128456_()) && (nbt1 == null || nbt1.m_128456_())) {
            return true;
        }
        if (nbt == null || nbt1 == null) {
            return false;
        }
        if (nbt1.m_128441_(POTION_TYPE_KEY) && !nbt.m_128441_(POTION_TYPE_KEY)) {
            CompoundTag n1 = nbt1.m_6426_();
            n1.m_128473_(POTION_TYPE_KEY);
            return n1.equals((Object)nbt);
        }
        if (nbt.m_128441_(POTION_TYPE_KEY) && !nbt1.m_128441_(POTION_TYPE_KEY)) {
            CompoundTag n = nbt.m_6426_();
            n.m_128473_(POTION_TYPE_KEY);
            return n.equals((Object)nbt1);
        }
        return nbt1.equals((Object)nbt);
    }
}

