/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids.forge;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.ISoftFluidTank;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.VanillaSoftFluids;
import net.mehvahdjukaar.moonlight.api.util.PotionNBTHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.client.SoftFluidClient;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class SoftFluidTank
implements ISoftFluidTank {
    private int count = 0;
    private final int capacity;
    @Nullable
    private CompoundTag nbt = null;
    @NotNull
    private SoftFluid fluid = VanillaSoftFluids.EMPTY.get();
    private int specialColor = 0;
    private boolean needsColorRefresh = true;

    public SoftFluidTank(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public boolean interactWithPlayer(Player player, InteractionHand hand, @Nullable Level world, @Nullable BlockPos pos) {
        ItemStack handStack = player.m_21120_(hand);
        ItemStack returnStack = this.interactWithItem(handStack, world, pos, false);
        if (returnStack != null) {
            Utils.swapItem(player, hand, returnStack);
            if (!handStack.m_41619_()) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)handStack.m_41720_()));
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public ItemStack interactWithItem(ItemStack stack, @Nullable Level world, @Nullable BlockPos pos, boolean simulate) {
        ItemStack returnStack = this.tryFillingItem(stack.m_41720_(), world, pos, simulate);
        if (returnStack != null) {
            return returnStack;
        }
        returnStack = this.tryDrainItem(stack, world, pos, simulate);
        return returnStack;
    }

    private void applyNBTtoItemStack(ItemStack stack) {
        List<String> nbtKey = this.fluid.getNbtKeyFromItem();
        if (this.nbt != null && !this.nbt.m_128456_()) {
            CompoundTag newCom = new CompoundTag();
            for (String s : nbtKey) {
                Tag c = this.nbt.m_128423_(s);
                if (c == null || s.equals("Bottle")) continue;
                newCom.m_128365_(s, c);
            }
            if (!newCom.m_128456_()) {
                stack.m_41751_(newCom);
            }
        }
    }

    private void addPotionTag(Item i, CompoundTag com) {
        String type = "REGULAR";
        if (i instanceof SplashPotionItem) {
            type = "SPLASH";
        } else if (i instanceof LingeringPotionItem) {
            type = "LINGERING";
        }
        com.m_128359_("Bottle", type);
    }

    @Override
    @Nullable
    public ItemStack tryDrainItem(ItemStack filledContainerStack, @Nullable Level world, @Nullable BlockPos pos, boolean simulate) {
        FluidContainerList.Category category;
        int amount;
        Optional<FluidContainerList.Category> optionalCategory;
        boolean hasCustomPot;
        Item filledContainer = filledContainerStack.m_41720_();
        SoftFluid s = SoftFluidRegistry.fromItem(filledContainer);
        if (s.isEmpty()) {
            return null;
        }
        CompoundTag com = filledContainerStack.m_41783_();
        CompoundTag newCom = new CompoundTag();
        Potion potion = PotionUtils.m_43579_((ItemStack)filledContainerStack);
        boolean bl = hasCustomPot = com != null && com.m_128441_("CustomPotionEffects");
        if (potion == Potions.f_43599_ && !hasCustomPot) {
            s = VanillaSoftFluids.WATER.get();
        } else if (potion != Potions.f_43598_ || hasCustomPot) {
            this.addPotionTag(filledContainer, newCom);
        }
        if (com != null) {
            for (String k : s.getNbtKeyFromItem()) {
                Tag c = com.m_128423_(k);
                if (c == null) continue;
                newCom.m_128365_(k, c);
            }
        }
        if (this.isEmpty()) {
            this.setFluid(s, newCom.m_128456_() ? null : newCom);
        }
        if ((optionalCategory = s.getContainerList().getCategoryFromFilled(filledContainer)).isPresent() && this.canAddSoftFluid(s, amount = (category = optionalCategory.get()).getAmount(), newCom)) {
            if (simulate) {
                return ItemStack.f_41583_;
            }
            this.grow(amount);
            SoundEvent sound = category.getEmptySound();
            if (sound != null && world != null && pos != null) {
                world.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return new ItemStack((ItemLike)category.getEmptyContainer());
        }
        return null;
    }

    @Override
    @Nullable
    public ItemStack tryFillingItem(Item emptyContainer, @Nullable Level world, @Nullable BlockPos pos, boolean simulate) {
        FluidContainerList.Category category;
        int amount;
        Optional<FluidContainerList.Category> opt = this.fluid.getContainerList().getCategoryFromEmpty(emptyContainer);
        if (opt.isPresent() && this.canRemove(amount = (category = opt.get()).getAmount())) {
            if (simulate) {
                return ItemStack.f_41583_;
            }
            ItemStack stack = new ItemStack((ItemLike)category.getFirstFilled().get());
            if (this.fluid == VanillaSoftFluids.POTION.get() && this.nbt != null && this.nbt.m_128441_("Bottle") && !Utils.getID(emptyContainer).m_135827_().equals("inspirations")) {
                String bottle = this.nbt.m_128461_("Bottle");
                if (bottle.equals("SPLASH")) {
                    stack = new ItemStack((ItemLike)Items.f_42736_);
                } else if (bottle.equals("LINGERING")) {
                    stack = new ItemStack((ItemLike)Items.f_42739_);
                }
            }
            if (emptyContainer == Items.f_42590_ && this.fluid == VanillaSoftFluids.WATER.get()) {
                stack = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_);
            }
            this.applyNBTtoItemStack(stack);
            this.shrink(amount);
            SoundEvent sound = category.getEmptySound();
            if (sound != null && world != null && pos != null) {
                world.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return stack;
        }
        return null;
    }

    public boolean isSameFluidAs(FluidStack fluidStack) {
        return this.isSameFluidAs(fluidStack, fluidStack.getTag());
    }

    public boolean isSameFluidAs(FluidStack fluidStack, CompoundTag com) {
        return this.fluid.isEquivalent(fluidStack.getFluid()) && ISoftFluidTank.areNbtEquals(com, this.nbt);
    }

    public boolean tryAddingFluid(FluidStack fluidStack) {
        int count = fluidStack.getAmount();
        SoftFluid s = SoftFluidRegistry.fromForgeFluid(this.fluid.getForgeFluid());
        return this.tryAddingFluid(s, count, fluidStack.getTag());
    }

    @Override
    public boolean tryAddingFluid(SoftFluid s, int count, @Nullable CompoundTag com) {
        if (this.canAdd(count)) {
            if (this.isEmpty()) {
                this.setFluid(s, com);
                this.setCount(count);
                return true;
            }
            if (this.isSameFluidAs(s, com)) {
                this.grow(count);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean tryTransferFluid(ISoftFluidTank destination, int amount) {
        if (destination.canAdd(amount) && this.canRemove(amount)) {
            if (destination.isEmpty()) {
                destination.setFluid(this.getFluid(), this.getNbt());
                this.shrink(amount);
                destination.grow(amount);
                return true;
            }
            if (this.isSameFluidAs(destination.getFluid(), destination.getNbt())) {
                this.shrink(amount);
                destination.grow(amount);
                return true;
            }
        }
        return false;
    }

    public boolean tryTransferToFluidTank(IFluidHandler fluidDestination, int bottles) {
        int fillableAmount;
        if (!this.canRemove(bottles)) {
            return false;
        }
        int milliBuckets = bottles * 250;
        FluidStack stack = this.toEquivalentForgeFluid(milliBuckets);
        if (!stack.isEmpty() && (fillableAmount = fluidDestination.fill(stack, IFluidHandler.FluidAction.SIMULATE)) == milliBuckets) {
            fluidDestination.fill(stack, IFluidHandler.FluidAction.EXECUTE);
            this.shrink(bottles);
            return true;
        }
        return false;
    }

    public boolean tryTransferToFluidTank(IFluidHandler fluidDestination) {
        return this.tryTransferToFluidTank(fluidDestination, 1);
    }

    public boolean drainFluidTank(IFluidHandler fluidSource, int bottles) {
        if (!this.canAdd(bottles)) {
            return false;
        }
        int milliBuckets = bottles * 250;
        FluidStack drainable = fluidSource.drain(milliBuckets, IFluidHandler.FluidAction.SIMULATE);
        if (!drainable.isEmpty() && drainable.getAmount() == milliBuckets) {
            boolean transfer = false;
            CompoundTag fsTag = drainable.getTag();
            if (this.fluid.isEmpty()) {
                this.setFluid(SoftFluidRegistry.fromForgeFluid(drainable.getFluid()), fsTag);
                transfer = true;
            } else if (this.isSameFluidAs(drainable, fsTag)) {
                transfer = true;
            }
            if (transfer) {
                fluidSource.drain(milliBuckets, IFluidHandler.FluidAction.EXECUTE);
                this.grow(bottles);
                return true;
            }
        }
        return false;
    }

    public boolean drainFluidTank(IFluidHandler fluidSource) {
        return this.drainFluidTank(fluidSource, 1);
    }

    public FluidStack toEquivalentForgeFluid(int mb) {
        FluidStack stack = new FluidStack(this.fluid.getForgeFluid(), mb);
        this.applyNBTtoFluidStack(stack);
        return stack;
    }

    private void applyNBTtoFluidStack(FluidStack fluidStack) {
        List<String> nbtKey = this.fluid.getNbtKeyFromItem();
        if (this.nbt != null && !this.nbt.m_128456_() && !fluidStack.isEmpty() && nbtKey != null) {
            CompoundTag newCom = new CompoundTag();
            for (String k : nbtKey) {
                Tag c;
                if (k.equals("Bottle") && Utils.getID(fluidStack.getFluid()).m_135827_().equals("immersiveengineering") || (c = this.nbt.m_128423_(k)) == null) continue;
                newCom.m_128365_(k, c);
            }
            if (!newCom.m_128456_()) {
                fluidStack.setTag(newCom);
            }
        }
    }

    @Override
    public boolean canRemove(int n) {
        return this.count >= n && !this.isEmpty();
    }

    @Override
    public boolean canAdd(int n) {
        return this.count + n <= this.capacity;
    }

    @Override
    public boolean isFull() {
        return this.count == this.capacity;
    }

    @Override
    public boolean isEmpty() {
        return this.fluid.isEmpty() || this.count <= 0;
    }

    @Override
    public void lossyAdd(int inc) {
        this.count = Math.min(this.capacity, this.count + inc);
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public void fillCount() {
        this.setCount(this.capacity);
    }

    @Override
    public void grow(int inc) {
        this.setCount(this.count + inc);
    }

    @Override
    public void shrink(int inc) {
        this.grow(-inc);
        if (this.count == 0) {
            this.clear();
        }
    }

    @Override
    public float getHeight(float maxHeight) {
        return maxHeight * (float)this.count / (float)this.capacity;
    }

    @Override
    public int getComparatorOutput() {
        float f = (float)this.count / (float)this.capacity;
        return Mth.m_14143_((float)(f * 14.0f)) + 1;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    @Nonnull
    public SoftFluid getFluid() {
        return this.fluid;
    }

    @Override
    @Nullable
    public CompoundTag getNbt() {
        return this.nbt;
    }

    @Override
    public void setNbt(@Nullable CompoundTag nbt) {
        this.nbt = nbt;
    }

    @Override
    public void clear() {
        this.fluid = VanillaSoftFluids.EMPTY.get();
        this.setCount(0);
        this.nbt = null;
        this.specialColor = 0;
    }

    @Override
    public void copy(ISoftFluidTank other) {
        this.setFluid(other.getFluid(), other.getNbt());
        this.setCount(Math.min(this.capacity, other.getCount()));
    }

    public void copy(IFluidHandler other) {
        FluidStack drainable = other.getFluidInTank(0).copy();
        CompoundTag nbt = drainable.isEmpty() ? null : drainable.getTag();
        this.setFluid(SoftFluidRegistry.fromForgeFluid(drainable.getFluid()), nbt);
        this.setCount(Math.min(this.capacity, other.getTankCapacity(0)));
    }

    public void fill(FluidStack fluidStack) {
        this.setFluid(fluidStack);
        this.fillCount();
    }

    public void setFluid(FluidStack fluidStack) {
        SoftFluid s = SoftFluidRegistry.fromForgeFluid(fluidStack.getFluid());
        this.setFluid(s, fluidStack.getTag());
    }

    @Override
    public void setFluid(@NotNull SoftFluid fluid, @Nullable CompoundTag nbt) {
        this.fluid = fluid;
        if (fluid == null) {
            boolean bl = true;
        }
        this.nbt = null;
        if (nbt != null) {
            this.nbt = nbt.m_6426_();
            if (fluid.equals(VanillaSoftFluids.POTION.get()) && !this.nbt.m_128441_("Bottle")) {
                this.nbt.m_128359_("Bottle", "REGULAR");
            }
        }
        this.specialColor = 0;
        if (this.fluid.isEmpty()) {
            this.setCount(0);
        }
        this.needsColorRefresh = true;
    }

    @Override
    public int getTintColor(@Nullable LevelReader world, @Nullable BlockPos pos) {
        SoftFluid.TintMethod method = this.fluid.getTintMethod();
        if (method == SoftFluid.TintMethod.NO_TINT) {
            return -1;
        }
        if (this.needsColorRefresh) {
            this.refreshSpecialColor(world, pos);
            this.needsColorRefresh = false;
        }
        if (this.specialColor != 0) {
            return this.specialColor;
        }
        return this.fluid.getTintColor();
    }

    @Override
    public int getFlowingTint(@Nullable LevelReader world, @Nullable BlockPos pos) {
        SoftFluid.TintMethod method = this.fluid.getTintMethod();
        if (method == SoftFluid.TintMethod.FLOWING) {
            return this.getParticleColor(world, pos);
        }
        return this.getTintColor(world, pos);
    }

    @Override
    public int getParticleColor(@Nullable LevelReader world, @Nullable BlockPos pos) {
        if (this.isEmpty()) {
            return -1;
        }
        int tintColor = this.getTintColor(world, pos);
        if (tintColor == -1) {
            return SoftFluidClient.get(this.fluid);
        }
        return tintColor;
    }

    private void refreshSpecialColor(@Nullable LevelReader world, @Nullable BlockPos pos) {
        if (this.fluid == VanillaSoftFluids.POTION.get()) {
            this.specialColor = PotionNBTHelper.getColorFromNBT(this.nbt);
        } else {
            int w;
            IClientFluidTypeExtensions prop;
            Fluid f = this.fluid.getForgeFluid();
            if (f != Fluids.f_76191_ && (prop = IClientFluidTypeExtensions.of((Fluid)f)) != IClientFluidTypeExtensions.DEFAULT && (w = prop.getTintColor(this.toEquivalentForgeFluid(1))) != -1) {
                this.specialColor = w;
            }
        }
    }

    @Override
    public boolean containsFood() {
        return this.fluid.isFood();
    }

    @Override
    public void load(CompoundTag compound) {
        if (compound.m_128441_("FluidHolder")) {
            CompoundTag cmp = compound.m_128469_("FluidHolder");
            this.count = cmp.m_128451_("Count");
            this.nbt = cmp.m_128469_("NBT");
            String id = cmp.m_128461_("Fluid");
            SoftFluid sf = SoftFluidRegistry.get(id);
            this.setFluid(sf, this.nbt);
        }
    }

    @Override
    public CompoundTag save(CompoundTag compound) {
        CompoundTag cmp = new CompoundTag();
        cmp.m_128405_("Count", this.count);
        cmp.m_128359_("Fluid", SoftFluidRegistry.getID(this.fluid).toString());
        cmp.m_128405_("CachedColor", this.getTintColor(null, null));
        if (this.nbt != null && !this.nbt.m_128456_()) {
            cmp.m_128365_("NBT", (Tag)this.nbt);
        }
        compound.m_128365_("FluidHolder", (Tag)cmp);
        return compound;
    }

    @Override
    public boolean tryDrinkUpFluid(Player player, Level world) {
        if (!this.isEmpty() && this.containsFood() && this.fluid.getFoodProvider().consume(player, world, this::applyNBTtoItemStack)) {
            this.shrink(1);
            return true;
        }
        return false;
    }

    public static int getLiquidCountFromItem(Item i) {
        if (i == Items.f_42590_) {
            return 1;
        }
        if (i == Items.f_42399_) {
            return 2;
        }
        if (i == Items.f_42446_) {
            return 4;
        }
        return 0;
    }
}

