/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.item;

import com.google.common.base.Suppliers;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class BlockTypeBasedBlockItem<T extends BlockType>
extends BlockItem {
    private final T blockType;
    private final Supplier<Integer> burnTime;

    public BlockTypeBasedBlockItem(Block pBlock, Item.Properties pProperties, T blockType) {
        super(pBlock, pProperties);
        this.blockType = blockType;
        this.burnTime = Suppliers.memoize(() -> PlatformHelper.getBurnTime(blockType.mainChild().m_5456_().m_7968_()));
        PlatformHelper.getPlatform().ifFabric(() -> {
            int b = this.burnTime.get();
            if (b != 0) {
                RegHelper.registerItemBurnTime((Item)this, b);
            }
        });
    }

    @PlatformOnly(value={"forge"})
    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        return this.burnTime.get();
    }

    public T getBlockType() {
        return this.blockType;
    }
}

