/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.item;

import com.google.common.base.Suppliers;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;

public class BlockTypeBasedItem<T extends BlockType>
extends Item {
    private final T blockType;
    private final Supplier<Integer> burnTime;
    private boolean init = false;

    public BlockTypeBasedItem(Item.Properties pProperties, T blockType) {
        super(pProperties);
        this.blockType = blockType;
        this.burnTime = Suppliers.memoize(() -> PlatformHelper.getBurnTime(blockType.mainChild().m_5456_().m_7968_()));
    }

    @PlatformOnly(value={"forge"})
    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        return this.burnTime.get();
    }

    protected boolean m_220152_(CreativeModeTab tab) {
        PlatformHelper.getPlatform().ifFabric(() -> {
            if (!this.init) {
                this.init = false;
                RegHelper.registerItemBurnTime(this, PlatformHelper.getBurnTime(((BlockType)this.blockType).mainChild().m_5456_().m_7968_()));
            }
        });
        if (((BlockType)this.blockType).mainChild().m_5456_().m_41471_() == null) {
            return false;
        }
        return super.m_220152_(tab);
    }

    public T getBlockType() {
        return this.blockType;
    }
}

