/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map;

import java.util.Arrays;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.integration.MapAtlasCompat;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;

public class MapHelper {
    public static final boolean mapAtlas = PlatformHelper.isModLoaded("map_atlases");

    @Nullable
    public static MapItemSavedData getMapData(ItemStack stack, Level level, @Nullable Player player) {
        MapItemSavedData data = MapItem.m_42853_((ItemStack)stack, (Level)level);
        if (data == null && mapAtlas && player != null) {
            data = MapAtlasCompat.getSavedDataFromAtlas(stack, level, player);
        }
        return data;
    }

    public static Integer getMapId(ItemStack stack, Player player, Object data) {
        Integer i = MapItem.m_151131_((ItemStack)stack);
        if (i == null && mapAtlas) {
            i = MapAtlasCompat.getMapIdFromAtlas(stack, player.f_19853_, data);
        }
        return i;
    }

    public static void addDecorationToMap(ItemStack stack, BlockPos pos, MapDecorationType<?, ?> type, int mapColor) {
        ListTag tags;
        if (stack.m_41782_() && stack.m_41783_().m_128425_("CustomDecorations", 9)) {
            tags = stack.m_41783_().m_128437_("CustomDecorations", 10);
        } else {
            tags = new ListTag();
            stack.m_41700_("CustomDecorations", (Tag)tags);
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", Utils.getID(type).toString());
        tag.m_128405_("x", pos.m_123341_());
        tag.m_128405_("z", pos.m_123343_());
        tags.add((Object)tag);
        if (mapColor != 0) {
            CompoundTag com = stack.m_41698_("display");
            com.m_128405_("MapColor", mapColor);
        }
    }

    public static void addVanillaDecorations(ItemStack stack, BlockPos pos, MapDecoration.Type type, int mapColor) {
        MapItemSavedData.m_77925_((ItemStack)stack, (BlockPos)pos, (String)"+", (MapDecoration.Type)type);
        if (mapColor != 0) {
            CompoundTag com = stack.m_41698_("display");
            com.m_128405_("MapColor", mapColor);
        }
    }

    public static void addDecorationToMap(ItemStack stack, BlockPos pos, ResourceLocation id, int mapColor) {
        Optional<MapDecoration.Type> opt;
        if (id.m_135827_().equals("minecraft") && (opt = Arrays.stream(MapDecoration.Type.values()).filter(t -> t.toString().toLowerCase().equals(id.m_135815_())).findFirst()).isPresent()) {
            MapHelper.addVanillaDecorations(stack, pos, opt.get(), mapColor);
            return;
        }
        MapDecorationType<? extends CustomMapDecoration, ?> type = MapDecorationRegistry.get(id.toString());
        if (type != null) {
            MapHelper.addDecorationToMap(stack, pos, type, mapColor);
        } else {
            MapHelper.addVanillaDecorations(stack, pos, MapDecoration.Type.TARGET_X, mapColor);
        }
    }

    public static boolean toggleMarkersAtPos(Level level, BlockPos pos, ItemStack stack, @Nullable Player player) {
        MapItemSavedData data = MapHelper.getMapData(stack, level, player);
        if (data instanceof ExpandedMapData) {
            ExpandedMapData expandedMapData = (ExpandedMapData)data;
            return expandedMapData.toggleCustomDecoration((LevelAccessor)level, pos);
        }
        return false;
    }

    public static boolean removeAllCustomMarkers(Level level, ItemStack stack, @Nullable Player player) {
        MapItemSavedData data = MapHelper.getMapData(stack, level, player);
        if (data instanceof ExpandedMapData) {
            ExpandedMapData expandedMapData = (ExpandedMapData)data;
            if (!level.f_46443_) {
                expandedMapData.resetCustomDecoration();
                return true;
            }
        }
        return false;
    }
}

