/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Stopwatch;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.core.misc.VanillaResourceManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class DynResourceProvider<T extends DynamicResourcePack>
implements PreparableReloadListener {
    public final T dynamicPack;
    private boolean hasBeenInitialized;

    protected DynResourceProvider(T pack) {
        this.dynamicPack = pack;
    }

    public void register() {
        ((DynamicResourcePack)this.dynamicPack).registerPack();
    }

    public abstract Logger getLogger();

    public T getPack() {
        return this.dynamicPack;
    }

    public abstract boolean dependsOnLoadedPacks();

    public abstract void regenerateDynamicAssets(ResourceManager var1);

    public void generateStaticAssetsOnStartup(ResourceManager manager) {
    }

    public final CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager manager, ProfilerFiller workerProfiler, ProfilerFiller mainProfiler, Executor workerExecutor, Executor mainExecutor) {
        this.reloadResources(manager);
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> null, workerExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenAcceptAsync(noResult -> {}, mainExecutor);
    }

    protected void reloadResources(ResourceManager manager) {
        Stopwatch watch = Stopwatch.createStarted();
        boolean resourcePackSupport = this.dependsOnLoadedPacks();
        if (!this.hasBeenInitialized) {
            this.hasBeenInitialized = true;
            this.generateStaticAssetsOnStartup(manager);
            T t = this.dynamicPack;
            if (t instanceof DynamicTexturePack) {
                DynamicTexturePack tp = (DynamicTexturePack)t;
                tp.addPackLogo();
            }
            if (!resourcePackSupport) {
                PackRepository pack = this.getRepository();
                if (pack != null) {
                    VanillaResourceManager vanillaManager = new VanillaResourceManager(pack);
                    this.regenerateDynamicAssets(vanillaManager);
                    vanillaManager.close();
                } else {
                    this.regenerateDynamicAssets(manager);
                }
            }
        }
        if (resourcePackSupport) {
            this.regenerateDynamicAssets(manager);
        }
        this.getLogger().info("Generated runtime {} for pack {} in: {} ms", (Object)((DynamicResourcePack)this.dynamicPack).getPackType(), (Object)((DynamicResourcePack)this.dynamicPack).m_8017_(), (Object)watch.elapsed().toMillis());
    }

    @Nullable
    protected abstract PackRepository getRepository();

    public boolean alreadyHasAssetAtLocation(ResourceManager manager, ResourceLocation res, ResType type) {
        ResourceLocation fullRes = type.getPath(res);
        Optional resource = manager.m_213713_(fullRes);
        return resource.filter(value -> !value.m_215506_().equals(((DynamicResourcePack)this.dynamicPack).m_8017_())).isPresent();
    }
}

