/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.textures;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSVColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.moonlight.api.util.math.kmeans.DataSet;
import net.mehvahdjukaar.moonlight.api.util.math.kmeans.IDataEntry;
import net.mehvahdjukaar.moonlight.api.util.math.kmeans.KMeans;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public final class SpriteUtils {
    @NotNull
    public static final Predicate<String> LOOKS_LIKE_TOP_LOG_TEXTURE = s -> (s = new ResourceLocation(s).m_135815_()).contains("_top") || s.contains("_end") || s.contains("_up");
    @NotNull
    public static final Predicate<String> LOOKS_LIKE_SIDE_LOG_TEXTURE = s -> !LOOKS_LIKE_TOP_LOG_TEXTURE.test((String)s);
    @NotNull
    public static final Predicate<String> LOOKS_LIKE_LEAF_TEXTURE = s -> !(s = new ResourceLocation(s).m_135815_()).contains("_bushy") && !s.contains("_snow");

    public static NativeImage readImage(ResourceManager manager, ResourceLocation resourceLocation) throws IOException, NoSuchElementException {
        NativeImage nativeImage;
        block8: {
            InputStream res = ((Resource)manager.m_213713_(resourceLocation).get()).m_215507_();
            try {
                nativeImage = NativeImage.m_85058_((InputStream)res);
                if (res == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            res.close();
        }
        return nativeImage;
    }

    public static void forEachPixel(NativeImage image, BiConsumer<Integer, Integer> function) {
        for (int x = 0; x < image.m_84982_(); ++x) {
            for (int y = 0; y < image.m_85084_(); ++y) {
                function.accept(x, y);
            }
        }
    }

    public static void grayscaleImage(NativeImage image) {
        SpriteUtils.forEachPixel(image, (x, y) -> image.m_84988_(x.intValue(), y.intValue(), new RGBColor(image.m_84985_(x.intValue(), y.intValue())).asHCL().withChroma(0.0f).asRGB().toInt()));
    }

    public static List<Palette> extrapolateSignBlockPalette(TextureImage planksTexture) {
        ArrayList<Palette> newPalettes = new ArrayList<Palette>();
        List<Palette> oakPalettes = Palette.fromAnimatedImage(planksTexture, null, 0.0033333334f);
        for (Palette palette : oakPalettes) {
            int size = palette.size();
            if (size == 7) {
                PaletteColor color = palette.get(size - 3);
                HSVColor hsv = color.rgb().asHSV();
                float satIncrease = 1.0638298f;
                float brightnessIncrease = 1.0638298f;
                HSVColor newCol = new HSVColor(hsv.hue(), Mth.m_14036_((float)(hsv.saturation() * satIncrease), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(hsv.value() * brightnessIncrease), (float)0.0f, (float)1.0f), hsv.alpha());
                PaletteColor newP = new PaletteColor(newCol);
                newP.occurrence = color.occurrence;
                palette.set(size - 1, newP);
                palette.remove(size - 2);
            }
            newPalettes.add(palette);
        }
        return newPalettes;
    }

    public static Palette extrapolateWoodItemPalette(TextureImage planksTexture) {
        Palette palette = Palette.fromAnimatedImage(planksTexture, null).get(0);
        PaletteColor color = palette.get(0);
        HSVColor hsv = color.rgb().asHSV();
        float satMult = 1.11f;
        float brightnessMult = 0.94f;
        HSVColor newCol = new HSVColor(hsv.hue(), Mth.m_14036_((float)(hsv.saturation() * satMult), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(hsv.value() * brightnessMult), (float)0.0f, (float)1.0f), hsv.alpha());
        PaletteColor newP = new PaletteColor(newCol);
        newP.occurrence = color.occurrence;
        palette.set(0, newP);
        return palette;
    }

    @Deprecated
    public static float getLuminance(int r, int g, int b) {
        return 0.299f * (float)r + 0.587f * (float)g + 0.114f * (float)b;
    }

    public static void reduceColors(NativeImage image, Function<Integer, Integer> sizeFn) {
        Palette p = Palette.fromImage(TextureImage.of(image, null), null, 0.0f);
        if (p.size() == 0) {
            return;
        }
        DataSet<DataSet.ColorPoint> data = DataSet.fromPalette(p);
        int size = sizeFn.apply(p.size());
        if (size >= p.size()) {
            return;
        }
        KMeans.kMeans(data, size);
        HashMap<Integer, Integer> colorToColorMap = new HashMap<Integer, Integer>();
        for (IDataEntry<DataSet.ColorPoint> c : data.getColorPoints()) {
            IDataEntry<DataSet.ColorPoint> centroid = data.getLastCentroids().get(c.getClusterNo());
            colorToColorMap.put(c.cast().getColor().value(), centroid.cast().getColor().value());
        }
        SpriteUtils.forEachPixel(image, (x, y) -> {
            int i = image.m_84985_(x.intValue(), y.intValue());
            if (colorToColorMap.containsKey(i)) {
                image.m_84988_(x.intValue(), y.intValue(), ((Integer)colorToColorMap.get(i)).intValue());
            }
        });
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static boolean looksLikeTopLogTexture(String s) {
        return (s = new ResourceLocation(s).m_135815_()).contains("_top") || s.contains("_end") || s.contains("_up");
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static boolean looksLikeSideLogTexture(String s) {
        return !SpriteUtils.looksLikeTopLogTexture(s);
    }
}

