/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public abstract class BlockType {
    private final Map<String, ItemLike> children = new HashMap<String, ItemLike>();
    boolean needsInit = true;
    public final ResourceLocation id;

    public BlockType(ResourceLocation resourceLocation) {
        this.id = resourceLocation;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getTypeName() {
        return this.id.m_135815_();
    }

    public String getNamespace() {
        return this.id.m_135827_();
    }

    public String getAppendableId() {
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public String toString() {
        return this.id.toString();
    }

    public abstract String getTranslationKey();

    public String getVariantId(String baseName) {
        String namespace;
        String string = namespace = this.isVanilla() ? "" : this.getNamespace() + "/";
        if (baseName.contains("%s")) {
            return namespace + String.format(baseName, this.getTypeName());
        }
        return namespace + baseName + "_" + this.getTypeName();
    }

    public String getVariantId(String baseName, boolean prefix) {
        return this.getVariantId(prefix ? baseName + "_%s" : "%s_" + baseName);
    }

    public String getVariantId(String postfix, String prefix) {
        return this.getVariantId(prefix + "_%s_" + postfix);
    }

    public String getReadableName() {
        return LangBuilder.getReadableName(this.getTypeName());
    }

    public boolean isVanilla() {
        return this.getNamespace().equals("minecraft");
    }

    @Nullable
    protected <V> V findRelatedEntry(String appendedName, Registry<V> reg) {
        return this.findRelatedEntry(appendedName, "", reg);
    }

    @Nullable
    protected <V> V findRelatedEntry(String append, String postPend, Registry<V> reg) {
        Object post = postPend.isEmpty() ? "" : "_" + postPend;
        ResourceLocation id = this.getId();
        ResourceLocation[] targets = new ResourceLocation[]{new ResourceLocation(id.m_135827_(), id.m_135815_() + "_" + append + (String)post), new ResourceLocation(id.m_135827_(), append + "_" + id.m_135815_() + (String)post), new ResourceLocation(id.m_135827_(), id.m_135815_() + "_planks_" + append + (String)post)};
        Object found = null;
        for (ResourceLocation r : targets) {
            if (!reg.m_7804_(r)) continue;
            found = reg.m_7745_(r);
            break;
        }
        return (V)found;
    }

    public Set<Map.Entry<String, ItemLike>> getChildren() {
        if (this.needsInit) {
            this.initAfterSetup();
        }
        return this.children.entrySet();
    }

    @Nullable
    public Item getItemOfThis(String key) {
        ItemLike v = this.getChild(key);
        return v == null ? null : v.m_5456_();
    }

    @Nullable
    public Block getBlockOfThis(String key) {
        Block b;
        ItemLike v = this.getChild(key);
        return v instanceof Block ? (b = (Block)v) : null;
    }

    @Nullable
    public ItemLike getChild(String key) {
        if (this.needsInit) {
            this.initAfterSetup();
        }
        return this.children.get(key);
    }

    public void addChild(String genericName, @Nullable ItemLike itemLike) {
        if (itemLike != null) {
            this.children.put(genericName, itemLike);
        }
    }

    protected abstract void initializeVanillaChildren();

    protected void initAfterSetup() {
        this.needsInit = false;
        this.initializeVanillaChildren();
    }

    public abstract ItemLike mainChild();

    @Nullable
    public static ItemLike changeItemBlockType(ItemLike current, BlockType originalMat, BlockType destinationMat) {
        if (destinationMat == originalMat) {
            return current;
        }
        for (Map.Entry<String, ItemLike> c : originalMat.getChildren()) {
            ItemLike child = c.getValue();
            ItemLike replacement = null;
            if (current instanceof Block && child instanceof Block) {
                if (current == child) {
                    replacement = destinationMat.getChild(c.getKey());
                }
            } else if (current.m_5456_() == c.getValue().m_5456_()) {
                replacement = destinationMat.getChild(c.getKey());
            }
            if (replacement == null) continue;
            return replacement;
        }
        return null;
    }

    public static abstract class SetFinder<T extends BlockType> {
        public abstract Optional<T> get();
    }
}

