/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.leaves;

import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class LeavesType
extends BlockType {
    public final Block leaves;
    public WoodType woodType;

    protected LeavesType(ResourceLocation id, Block leaves) {
        super(id);
        this.leaves = leaves;
    }

    @Override
    public ItemLike mainChild() {
        return this.leaves;
    }

    @Override
    public String getTranslationKey() {
        return "leaves_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    protected void initializeVanillaChildren() {
        this.addChild("leaves", (ItemLike)this.leaves);
        this.woodType = WoodTypeRegistry.getValue(this.id);
    }

    public static class Finder
    extends BlockType.SetFinder<LeavesType> {
        private final Supplier<Block> leavesFinder;
        private final ResourceLocation id;

        public Finder(ResourceLocation id, Supplier<Block> leaves) {
            this.id = id;
            this.leavesFinder = leaves;
        }

        public static Finder simple(String modId, String leavesTypeName, String leavesName) {
            return new Finder(new ResourceLocation(modId, leavesTypeName), () -> (Block)Registry.f_122824_.m_7745_(new ResourceLocation(modId, leavesName)));
        }

        @Override
        public Optional<LeavesType> get() {
            if (PlatformHelper.isModLoaded(this.id.m_135827_())) {
                try {
                    Block leaves = this.leavesFinder.get();
                    Block d = (Block)Registry.f_122824_.m_7745_(Registry.f_122824_.m_122315_());
                    if (leaves != d && leaves != null) {
                        return Optional.of(new LeavesType(this.id, leaves));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Moonlight.LOGGER.warn("Failed to find custom wood type {}", (Object)this.id);
            }
            return Optional.empty();
        }
    }
}

