/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.wood;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class WoodType
extends BlockType {
    public final Material material;
    public final Block planks;
    public final Block log;
    @Nullable
    private final net.minecraft.world.level.block.state.properties.WoodType vanillaType;

    protected WoodType(ResourceLocation id, Block baseBlock, Block logBlock) {
        super(id);
        this.planks = baseBlock;
        this.log = logBlock;
        this.material = baseBlock.m_49966_().m_60767_();
        String i = id.m_135827_().equals("minecraft") ? "" : id.m_135827_() + "/" + id.m_135815_();
        Optional<net.minecraft.world.level.block.state.properties.WoodType> o = net.minecraft.world.level.block.state.properties.WoodType.m_61843_().filter(v -> v.m_61846_().equals(i)).findAny();
        this.vanillaType = o.orElse(null);
    }

    @Nullable
    protected Block findLogRelatedBlock(String append, String postpend) {
        Object post = postpend.isEmpty() ? "" : "_" + postpend;
        ResourceLocation id = this.getId();
        String log = Utils.getID(this.log).m_135815_();
        ResourceLocation[] targets = new ResourceLocation[]{new ResourceLocation(id.m_135827_(), log + "_" + append + (String)post), new ResourceLocation(id.m_135827_(), append + "_" + log + (String)post), new ResourceLocation(id.m_135827_(), id.m_135815_() + "_" + append + (String)post), new ResourceLocation(id.m_135827_(), append + "_" + id.m_135815_() + (String)post)};
        Block found = null;
        for (ResourceLocation r : targets) {
            if (!Registry.f_122824_.m_7804_(r)) continue;
            found = (Block)Registry.f_122824_.m_7745_(r);
            break;
        }
        return found;
    }

    public Material getMaterial() {
        return this.material;
    }

    @Override
    public ItemLike mainChild() {
        return this.planks;
    }

    @Nullable
    public net.minecraft.world.level.block.state.properties.WoodType toVanilla() {
        return this.vanillaType;
    }

    public String getTexturePath() {
        String namespace = this.getNamespace();
        if (namespace.equals("minecraft")) {
            return this.getTypeName();
        }
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public boolean canBurn() {
        return this.material.m_76335_();
    }

    public MaterialColor getColor() {
        return this.material.m_76339_();
    }

    @Override
    public String getTranslationKey() {
        return "wood_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    protected void initializeVanillaChildren() {
        this.addChild("planks", (ItemLike)this.planks);
        this.addChild("log", (ItemLike)this.log);
        this.addChild("leaves", (ItemLike)this.findRelatedEntry("leaves", Registry.f_122824_));
        this.addChild("stripped_log", (ItemLike)this.findLogRelatedBlock("stripped", "log"));
        this.addChild("stripped_wood", (ItemLike)this.findLogRelatedBlock("stripped", "wood"));
        this.addChild("wood", (ItemLike)this.findRelatedEntry("wood", Registry.f_122824_));
        this.addChild("slab", (ItemLike)this.findRelatedEntry("slab", Registry.f_122824_));
        this.addChild("stairs", (ItemLike)this.findRelatedEntry("stairs", Registry.f_122824_));
        this.addChild("fence", (ItemLike)this.findRelatedEntry("fence", Registry.f_122824_));
        this.addChild("fence_gate", (ItemLike)this.findRelatedEntry("fence_gate", Registry.f_122824_));
        this.addChild("door", (ItemLike)this.findRelatedEntry("door", Registry.f_122824_));
        this.addChild("trapdoor", (ItemLike)this.findRelatedEntry("trapdoor", Registry.f_122824_));
        this.addChild("button", (ItemLike)this.findRelatedEntry("button", Registry.f_122824_));
        this.addChild("pressure_plate", (ItemLike)this.findRelatedEntry("pressure_plate", Registry.f_122824_));
        this.addChild("boat", (ItemLike)this.findRelatedEntry("boat", Registry.f_122827_));
        this.addChild("sign", (ItemLike)this.findRelatedEntry("sign", Registry.f_122827_));
    }

    public static class Finder
    extends BlockType.SetFinder<WoodType> {
        private final Map<String, ResourceLocation> childNames = new HashMap<String, ResourceLocation>();
        private final Supplier<Block> planksFinder;
        private final Supplier<Block> logFinder;
        private final ResourceLocation id;

        public Finder(ResourceLocation id, Supplier<Block> planks, Supplier<Block> log) {
            this.id = id;
            this.planksFinder = planks;
            this.logFinder = log;
        }

        public static Finder simple(String modId, String woodTypeName, String planksName, String logName) {
            return Finder.simple(new ResourceLocation(modId, woodTypeName), new ResourceLocation(modId, planksName), new ResourceLocation(modId, logName));
        }

        public static Finder simple(ResourceLocation woodTypeName, ResourceLocation planksName, ResourceLocation logName) {
            return new Finder(woodTypeName, () -> (Block)Registry.f_122824_.m_7745_(planksName), () -> (Block)Registry.f_122824_.m_7745_(logName));
        }

        public void addChild(String childType, String childName) {
            this.addChild(childType, new ResourceLocation(this.id.m_135827_(), childName));
        }

        public void addChild(String childType, ResourceLocation childName) {
            this.childNames.put(childType, childName);
        }

        @Override
        @ApiStatus.Internal
        public Optional<WoodType> get() {
            if (PlatformHelper.isModLoaded(this.id.m_135827_())) {
                try {
                    Block plank = this.planksFinder.get();
                    Block log = this.logFinder.get();
                    Block d = (Block)Registry.f_122824_.m_7745_(Registry.f_122824_.m_122315_());
                    if (plank != d && log != d && plank != null && log != null) {
                        WoodType w = new WoodType(this.id, plank, log);
                        this.childNames.forEach((key, value) -> w.addChild((String)key, (ItemLike)Registry.f_122824_.m_7745_(value)));
                        return Optional.of(w);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Moonlight.LOGGER.warn("Failed to find custom wood type {}", (Object)this.id);
            }
            return Optional.empty();
        }
    }
}

