/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class StoneCutterRecipeTemplate
implements IRecipeTemplate<SingleItemRecipeBuilder.Result> {
    private final List<Object> conditions = new ArrayList<Object>();
    public final Item result;
    public final int count;
    public final String group;
    public final Ingredient ingredient;

    public StoneCutterRecipeTemplate(JsonObject json) {
        JsonElement result = json.get("result");
        ResourceLocation item = new ResourceLocation(result.getAsString());
        int count = 1;
        JsonElement c = json.get("count");
        if (c != null) {
            count = c.getAsInt();
        }
        this.count = count;
        this.result = (Item)Registry.f_122827_.m_7745_(item);
        JsonElement g = json.get("group");
        this.group = g == null ? "" : g.getAsString();
        this.ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
    }

    @Override
    public <T extends BlockType> SingleItemRecipeBuilder.Result createSimilar(T originalMat, T destinationMat, Item unlockItem, @Nullable String id) {
        ItemLike newRes = BlockType.changeItemBlockType((ItemLike)this.result, originalMat, destinationMat);
        if (newRes == null) {
            throw new UnsupportedOperationException(String.format("Could not convert output item %s from type %s to %s", this.result, originalMat, destinationMat));
        }
        if (newRes.m_5456_().m_41471_() == null) {
            Moonlight.LOGGER.error("Failed to generate recipe for {} in block type {}: Output item {} cannot have empty creative tab, skipping", (Object)this.result, destinationMat, (Object)newRes);
            return null;
        }
        boolean atLeastOneChanged = false;
        Ingredient ing = this.ingredient;
        for (ItemStack in : ing.m_43908_()) {
            ItemLike i;
            Item it = in.m_41720_();
            if (it == Items.f_42127_ || (i = BlockType.changeItemBlockType((ItemLike)it, originalMat, destinationMat)) == null) continue;
            atLeastOneChanged = true;
            ing = Ingredient.m_43929_((ItemLike[])new ItemLike[]{i});
            break;
        }
        if (!atLeastOneChanged) {
            return null;
        }
        SingleItemRecipeBuilder builder = SingleItemRecipeBuilder.m_126313_((Ingredient)ing, (ItemLike)newRes);
        builder.m_126145_(this.group);
        builder.m_126132_("has_planks", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{unlockItem}));
        AtomicReference newRecipe = new AtomicReference();
        if (id == null) {
            builder.m_176498_(r -> newRecipe.set((SingleItemRecipeBuilder.Result)r));
        } else {
            builder.m_176500_(r -> newRecipe.set((SingleItemRecipeBuilder.Result)r), id);
        }
        return (SingleItemRecipeBuilder.Result)newRecipe.get();
    }

    @Override
    public List<Object> getConditions() {
        return this.conditions;
    }

    @Override
    public void addCondition(Object condition) {
        this.conditions.add(condition);
    }
}

