/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.set;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.set.forge.BlockSetInternalImpl;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class BlockSetInternal {
    private static final Map<Class<? extends BlockType>, BlockTypeRegistry<?>> BLOCK_SET_CONTAINERS = new ConcurrentHashMap();
    private static final ConcurrentLinkedDeque<Runnable> FINDER_ADDER = new ConcurrentLinkedDeque();
    private static final ConcurrentLinkedDeque<Runnable> REMOVER_ADDER = new ConcurrentLinkedDeque();

    public static void initializeBlockSets() {
        if (BlockSetInternal.hasFilledBlockSets()) {
            throw new UnsupportedOperationException("block sets have already bee initialized");
        }
        FINDER_ADDER.forEach(Runnable::run);
        FINDER_ADDER.clear();
        BLOCK_SET_CONTAINERS.values().forEach(BlockTypeRegistry::buildAll);
        REMOVER_ADDER.forEach(Runnable::run);
        REMOVER_ADDER.clear();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    protected static boolean hasFilledBlockSets() {
        return BlockSetInternalImpl.hasFilledBlockSets();
    }

    public static <T extends BlockType> void registerBlockSetDefinition(BlockTypeRegistry<T> typeRegistry) {
        if (BlockSetInternal.hasFilledBlockSets()) {
            throw new UnsupportedOperationException(String.format("Tried to register block set definition %s after registry events", typeRegistry));
        }
        BLOCK_SET_CONTAINERS.put(typeRegistry.getType(), typeRegistry);
    }

    public static <T extends BlockType> void addBlockTypeFinder(Class<T> type, BlockType.SetFinder<T> blockFinder) {
        if (BlockSetInternal.hasFilledBlockSets()) {
            throw new UnsupportedOperationException(String.format("Tried to register block %s finder %s after registry events", type, blockFinder));
        }
        FINDER_ADDER.add(() -> {
            BlockTypeRegistry container = BlockSetInternal.getBlockSet(type);
            container.addFinder(blockFinder);
        });
    }

    public static <T extends BlockType> void addBlockTypeRemover(Class<T> type, ResourceLocation id) {
        if (BlockSetInternal.hasFilledBlockSets()) {
            throw new UnsupportedOperationException(String.format("Tried to remove block type %s for type %s after registry events", id, type));
        }
        REMOVER_ADDER.add(() -> {
            BlockTypeRegistry container = BlockSetInternal.getBlockSet(type);
            container.addRemover(id);
        });
    }

    public static <T extends BlockType> BlockTypeRegistry<T> getBlockSet(Class<T> type) {
        return BLOCK_SET_CONTAINERS.get(type);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends BlockType> void addDynamicBlockRegistration(BlockSetAPI.BlockTypeRegistryCallback<Block, T> registrationFunction, Class<T> blockType) {
        void var1_1;
        BlockSetInternalImpl.addDynamicBlockRegistration(registrationFunction, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends BlockType> void addDynamicItemRegistration(BlockSetAPI.BlockTypeRegistryCallback<Item, T> registrationFunction, Class<T> blockType) {
        void var1_1;
        BlockSetInternalImpl.addDynamicItemRegistration(registrationFunction, var1_1);
    }

    public static Collection<BlockTypeRegistry<?>> getRegistries() {
        return BLOCK_SET_CONTAINERS.values();
    }

    @Nullable
    public static BlockTypeRegistry<?> getRegistry(Class<? extends BlockType> typeClass) {
        return BLOCK_SET_CONTAINERS.get(typeClass);
    }

    @FunctionalInterface
    public static interface BlockTypeRegistryCallback<E, T extends BlockType> {
        public void accept(Registrator<E> var1, Collection<T> var2);
    }
}

