/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.set.forge;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;

public class BlockSetInternalImpl {
    private static final Map<String, Pair<List<Runnable>, List<Consumer<Registrator<Item>>>>> LATE_REGISTRATION_QUEUE = new ConcurrentHashMap<String, Pair<List<Runnable>, List<Consumer<Registrator<Item>>>>>();
    private static boolean hasFilledBlockSets = false;

    public static <T extends BlockType> void addDynamicBlockRegistration(BlockSetAPI.BlockTypeRegistryCallback<Block, T> registrationFunction, Class<T> blockType) {
        Pair<List<Runnable>, List<Consumer<Registrator<Item>>>> registrationQueues = BlockSetInternalImpl.getOrAddQueue();
        Consumer<RegisterEvent> eventConsumer = e -> {
            if (e.getRegistryKey().equals((Object)ForgeRegistries.BLOCKS.getRegistryKey())) {
                Runnable lateRegistration = () -> {
                    IForgeRegistry registry = e.getForgeRegistry();
                    if (registry instanceof ForgeRegistry) {
                        ForgeRegistry fr = (ForgeRegistry)registry;
                        boolean frozen = fr.isLocked();
                        fr.unfreeze();
                        registrationFunction.accept((arg_0, arg_1) -> ((IForgeRegistry)registry).register(arg_0, arg_1), BlockSetAPI.getBlockSet(blockType).getValues());
                        if (frozen) {
                            fr.freeze();
                        }
                    }
                };
                ((List)registrationQueues.getFirst()).add(lateRegistration);
            }
        };
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(EventPriority.HIGHEST, eventConsumer);
    }

    public static <T extends BlockType> void addDynamicItemRegistration(BlockSetAPI.BlockTypeRegistryCallback<Item, T> registrationFunction, Class<T> blockType) {
        Pair<List<Runnable>, List<Consumer<Registrator<Item>>>> registrationQueues = BlockSetInternalImpl.getOrAddQueue();
        Consumer<Registrator> itemEvent = e -> registrationFunction.accept((Registrator<Item>)e, BlockSetAPI.getBlockSet(blockType).getValues());
        ((List)registrationQueues.getSecond()).add(itemEvent);
    }

    @NotNull
    private static Pair<List<Runnable>, List<Consumer<Registrator<Item>>>> getOrAddQueue() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        String modId = ModLoadingContext.get().getActiveContainer().getModId();
        return LATE_REGISTRATION_QUEUE.computeIfAbsent(modId, s -> {
            bus.addListener(EventPriority.HIGHEST, BlockSetInternalImpl::registerLateBlockAndItems);
            return Pair.of(new ArrayList(), new ArrayList());
        });
    }

    protected static void registerLateBlockAndItems(RegisterEvent event) {
        String modId;
        Pair<List<Runnable>, List<Consumer<Registrator<Item>>>> registrationQueues;
        if (!event.getRegistryKey().equals((Object)ForgeRegistries.ITEMS.getRegistryKey())) {
            return;
        }
        if (!hasFilledBlockSets) {
            BlockSetInternal.initializeBlockSets();
            hasFilledBlockSets = true;
        }
        if ((registrationQueues = LATE_REGISTRATION_QUEUE.get(modId = ModLoadingContext.get().getActiveContainer().getModId())) != null) {
            IForgeRegistry fr = event.getForgeRegistry();
            List blockQueue = (List)registrationQueues.getFirst();
            blockQueue.forEach(Runnable::run);
            List itemQueue = (List)registrationQueues.getSecond();
            itemQueue.forEach(q -> q.accept((arg_0, arg_1) -> ((IForgeRegistry)fr).register(arg_0, arg_1)));
        }
        LATE_REGISTRATION_QUEUE.remove(modId);
    }

    public static boolean hasFilledBlockSets() {
        return hasFilledBlockSets;
    }
}

