/*
 * Decompiled with CFR 0.152.
 */
package com.toadstoolstudios.sprout.config;

import com.toadstoolstudios.sprout.config.AnnotationData;
import com.toadstoolstudios.sprout.config.BuiltCategory;
import com.toadstoolstudios.sprout.config.BuiltConfig;
import com.toadstoolstudios.sprout.config.PropertyData;
import com.toadstoolstudios.sprout.config.PropertyType;
import com.toadstoolstudios.sprout.config.annotations.Category;
import com.toadstoolstudios.sprout.config.annotations.Config;
import com.toadstoolstudios.sprout.config.annotations.Property;
import com.toadstoolstudios.sprout.config.forge.ConfigLoaderImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.reflect.Field;

public class ConfigLoader {
    public static void registerConfig(Object object) {
        BuiltCategory category;
        try {
            category = ConfigLoader.buildCategory(null, object);
        }
        catch (Exception e) {
            e.printStackTrace();
            category = null;
        }
        if (!(category instanceof BuiltConfig)) {
            throw new IllegalArgumentException("Config supplied does not have a @Config annotation");
        }
        BuiltConfig config = (BuiltConfig)category;
        ConfigLoader.registerConfig(config);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerConfig(BuiltConfig config) {
        ConfigLoaderImpl.registerConfig(config);
    }

    public static BuiltCategory buildCategory(String categoryDesc, Object object) throws IllegalAccessException {
        BuiltCategory category;
        Class<?> configClass = object.getClass();
        if (configClass.isAnnotationPresent(Config.class)) {
            category = new BuiltConfig(configClass.getAnnotation(Config.class).value());
        } else if (configClass.isAnnotationPresent(Category.class)) {
            category = new BuiltCategory(categoryDesc, configClass.getAnnotation(Category.class).value());
        } else {
            throw new IllegalStateException("Config does not contain any @Config annotation or @Category");
        }
        for (Field field : configClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Property.class) || !field.canAccess(object)) continue;
            PropertyType type = field.getAnnotation(Property.class).type();
            if (type.equals((Object)PropertyType.CATEGORY)) {
                category.categories.add(ConfigLoader.buildCategory(field.getAnnotation(Property.class).description(), field.get(object)));
                continue;
            }
            category.properties.add(new PropertyData(object, field, AnnotationData.getData(field)));
        }
        return category;
    }
}

