/*
 * Decompiled with CFR 0.152.
 */
package com.toadstoolstudios.sprout.entities;

import com.toadstoolstudios.sprout.entities.BounceBugVariant;
import com.toadstoolstudios.sprout.entities.Herbivore;
import com.toadstoolstudios.sprout.entities.goals.FindPlantGoal;
import com.toadstoolstudios.sprout.entities.goals.SpreadShroomOrGrowWartGoal;
import com.toadstoolstudios.sprout.entities.goals.SproutWanderGoal;
import com.toadstoolstudios.sprout.registry.SproutEntities;
import com.toadstoolstudios.sprout.registry.SproutItems;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FungusBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class BounceBugEntity
extends TamableAnimal
implements IAnimatable,
Herbivore {
    private static final EntityDataAccessor<BounceBugVariant> BOUNCE_BUG_VARIANT = SynchedEntityData.m_135353_(BounceBugEntity.class, SproutEntities.BOUNCE_BUG_VARIANT);
    protected static final EntityDataAccessor<Boolean> SPREADING_SPORES = SynchedEntityData.m_135353_(BounceBugEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private BlockPos shroomPos;
    public final boolean isInJar;

    public BounceBugEntity(EntityType<BounceBugEntity> entityType, Level world) {
        this(entityType, world, false);
    }

    public BounceBugEntity(EntityType<BounceBugEntity> entityType, Level world, boolean isInJar) {
        super(entityType, world);
        this.isInJar = isInJar;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public static boolean canSpawn(EntityType<BounceBugEntity> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, Random random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13077_);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        Holder biome = world.m_204166_(this.m_142538_());
        if (biome.m_203565_(Biomes.f_48200_)) {
            this.setBounceBugVariant(BounceBugVariant.CRIMSON);
        }
        if (MobSpawnType.SPAWN_EGG.equals((Object)spawnReason) && !biome.m_203565_(Biomes.f_48201_)) {
            this.setBounceBugVariant(BounceBugVariant.random(world.m_5822_()));
        }
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42590_)) {
            if (!this.f_19853_.m_5776_()) {
                this.setIfSpreadingSpores(false);
                stack.m_41774_(1);
                CompoundTag bugNbt = new CompoundTag();
                this.m_20086_(bugNbt);
                ItemStack bugBottle = new ItemStack((ItemLike)SproutItems.BOUNCE_BUG_JAR.get());
                bugBottle.m_41784_().m_128365_("bug", (Tag)bugNbt);
                player.m_150109_().m_150079_(bugBottle);
                this.m_146870_();
                return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
            }
        } else if (this.m_142480_() != null) {
            if (!this.m_21827_()) {
                Block blockFromItem = Block.m_49814_((Item)stack.m_41720_());
                if (blockFromItem instanceof FungusBlock || blockFromItem instanceof MushroomBlock) {
                    if (!this.f_19853_.m_5776_()) {
                        this.m_21839_(true);
                    }
                    this.setIfSpreadingSpores(false);
                    ItemStack heldItem = stack.m_41777_();
                    stack.m_41774_(1);
                    heldItem.m_41764_(1);
                    this.m_21008_(InteractionHand.MAIN_HAND, heldItem);
                    return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
                }
            } else {
                if (!this.f_19853_.m_5776_()) {
                    this.m_21839_(false);
                }
                player.m_150109_().m_150079_(this.m_21120_(InteractionHand.MAIN_HAND).m_41777_());
                this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
            }
        }
        return super.m_6071_(player, hand);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BOUNCE_BUG_VARIANT, (Object)BounceBugVariant.WARPED);
        this.f_19804_.m_135372_(SPREADING_SPORES, (Object)false);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("bugType", this.getBounceBugVariant().name());
        nbt.m_128379_("isSpreadingSpores", this.isSpreadingSpores());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("bugType")) {
            this.setBounceBugVariant(BounceBugVariant.getVariant(nbt.m_128461_("bugType")));
        }
        if (nbt.m_128441_("isSpreadingSpores")) {
            this.setIfSpreadingSpores(nbt.m_128471_("isSpreadingSpores"));
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 0.3));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, new FindPlantGoal<BounceBugEntity>(this, block -> block instanceof NetherWartBlock || block instanceof MushroomBlock || block instanceof FungusBlock));
        this.f_21345_.m_25352_(3, (Goal)new SpreadShroomOrGrowWartGoal(this));
        this.f_21345_.m_25352_(8, new SproutWanderGoal<BounceBugEntity>(this, 0.2));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        this.m_21839_(false);
        this.setIfSpreadingSpores(false);
        return super.m_6469_(source, amount);
    }

    public boolean isNearBlock(BlockPos pos, int range) {
        return pos != null && pos.m_203193_((Position)this.m_20182_()) < (double)(range * range);
    }

    public boolean isNearShroom() {
        return this.isNearBlock(this.getTargetPlant(), 3);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return null;
    }

    @Override
    public boolean isNotBusy() {
        return !this.isSpreadingSpores();
    }

    @Override
    public void setTargetPlant(BlockPos pos) {
        this.shroomPos = pos;
    }

    @Override
    @Nullable
    public BlockPos getTargetPlant() {
        return this.shroomPos;
    }

    private void setBounceBugVariant(BounceBugVariant variant) {
        this.f_19804_.m_135381_(BOUNCE_BUG_VARIANT, (Object)variant);
    }

    public BounceBugVariant getBounceBugVariant() {
        return (BounceBugVariant)((Object)this.f_19804_.m_135370_(BOUNCE_BUG_VARIANT));
    }

    public void setIfSpreadingSpores(boolean isSpreadingSpores) {
        this.f_19804_.m_135381_(SPREADING_SPORES, (Object)isSpreadingSpores);
    }

    public boolean isSpreadingSpores() {
        return (Boolean)this.f_19804_.m_135370_(SPREADING_SPORES);
    }

    @Override
    public boolean specialPredicate() {
        return !this.isSpreadingSpores();
    }

    private <E extends IAnimatable> PlayState walkCycle(AnimationEvent<E> event) {
        if (!this.m_21825_()) {
            if (event.isMoving()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.bounce_bug.walking", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.bounce_bug.idling", Boolean.valueOf(true)));
            }
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState sitStand(AnimationEvent<E> event) {
        if (this.m_21825_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.bounce_bug.sitting", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState actions(AnimationEvent<E> event) {
        if (!event.isMoving() && !this.m_21825_() && this.isSpreadingSpores()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.bounce_bug.wiggling", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "walk_cycle", 0.0f, this::walkCycle));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "sitting_cycle", 0.0f, this::sitStand));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "action_cycles", 5.0f, this::actions));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

