/*
 * Decompiled with CFR 0.152.
 */
package com.toadstoolstudios.sprout.entities.goals;

import com.toadstoolstudios.sprout.entities.ElephantEntity;
import com.toadstoolstudios.sprout.utils.EntityPathingUtils;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class DrinkWaterGoal
extends Goal {
    private int drinkTimer;
    private final int timerCap;
    private final ElephantEntity elephant;
    private static final List<BlockPos> POSITIONAL_OFFSETS = EntityPathingUtils.getPositionalOffsets(1);

    public DrinkWaterGoal(ElephantEntity elephant, int timeInSeconds) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET, Goal.Flag.LOOK));
        this.elephant = elephant;
        this.timerCap = timeInSeconds * 20;
    }

    public boolean m_8036_() {
        if (this.elephant.m_142480_() != null && !this.elephant.hasWater()) {
            return !this.elephant.isWatering() && !this.elephant.hasWater() && this.elephant.isNearWater() && this.checkForWater();
        }
        return false;
    }

    public void m_8056_() {
        super.m_8056_();
        this.drinkTimer = 0;
        this.elephant.m_7618_(this.elephant.m_20203_().m_81378_(), Vec3.m_82512_((Vec3i)this.elephant.getWaterPos()));
        this.elephant.setDrinking(true);
    }

    public void m_8037_() {
        super.m_8037_();
        this.elephant.m_7618_(this.elephant.m_20203_().m_81378_(), Vec3.m_82512_((Vec3i)this.elephant.getWaterPos()));
    }

    public boolean m_8045_() {
        return this.checkForWater() && this.drinkTimer++ <= this.timerCap && this.elephant.isNearWater();
    }

    public void m_8041_() {
        super.m_8041_();
        this.elephant.setDrinking(false);
        this.elephant.setWaterPos(null);
        if (this.drinkTimer >= this.timerCap) {
            this.elephant.setIfHasWater(true);
        }
    }

    public boolean checkForWater() {
        BlockPos.MutableBlockPos waterPos = this.elephant.m_142538_().m_122032_();
        for (BlockPos blockPos : POSITIONAL_OFFSETS) {
            waterPos.m_175306_((Vec3i)this.elephant.m_142538_(), (Vec3i)blockPos);
            if (!this.elephant.f_19853_.m_46801_((BlockPos)waterPos)) continue;
            return true;
        }
        return false;
    }
}

