/*
 * Decompiled with CFR 0.152.
 */
package com.toadstoolstudios.sprout.forge;

import com.toadstoolstudios.sprout.Sprout;
import com.toadstoolstudios.sprout.config.forge.ConfigLoaderImpl;
import com.toadstoolstudios.sprout.entities.BounceBugEntity;
import com.toadstoolstudios.sprout.entities.ElephantEntity;
import com.toadstoolstudios.sprout.forge.SproutForgeClient;
import com.toadstoolstudios.sprout.registry.SpawnData;
import com.toadstoolstudios.sprout.registry.SproutConfiguredFeatures;
import com.toadstoolstudios.sprout.registry.SproutEntities;
import com.toadstoolstudios.sprout.registry.SproutItems;
import com.toadstoolstudios.sprout.registry.forge.SproutBlocksImpl;
import com.toadstoolstudios.sprout.registry.forge.SproutConfiguredFeaturesImpl;
import com.toadstoolstudios.sprout.registry.forge.SproutEntitiesImpl;
import com.toadstoolstudios.sprout.registry.forge.SproutFeaturesImpl;
import com.toadstoolstudios.sprout.registry.forge.SproutItemsImpl;
import com.toadstoolstudios.sprout.registry.forge.SproutParticlesImpl;
import com.toadstoolstudios.sprout.registry.forge.SproutSoundsImpl;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="sprout")
public class SproutForge {
    private static boolean addSpawns = false;

    public SproutForge() {
        Sprout.init();
        ConfigLoaderImpl.initialize();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        SproutEntitiesImpl.ENTITY_TYPES.register(bus);
        SproutBlocksImpl.BLOCKS.register(bus);
        SproutBlocksImpl.BLOCK_ENTITIES.register(bus);
        SproutItemsImpl.ITEMS.register(bus);
        SproutSoundsImpl.SOUNDS.register(bus);
        SproutParticlesImpl.PARTICLES.register(bus);
        SproutFeaturesImpl.FEATURES.register(bus);
        bus.addListener(SproutForge::commonSetup);
        bus.addListener(SproutForgeClient::clientSetup);
        bus.addListener(SproutForge::onComplete);
        bus.addListener(SproutForge::entityAttributeStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        SproutConfiguredFeatures.registerFeatures();
    }

    public static void onComplete(FMLLoadCompleteEvent event) {
        SproutEntities.addSpawnRules();
        SproutItems.onComplete();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void addSpawns(BiomeLoadingEvent event) {
        ResourceLocation name;
        if (!addSpawns) {
            SproutEntities.addSpawns();
            addSpawns = true;
        }
        if ((name = event.getName()) != null) {
            List spawns = SproutEntitiesImpl.ENTITY_SPAWNS.get((Object)name);
            for (SpawnData spawnData : spawns) {
                event.getSpawns().m_48376_(spawnData.group(), new MobSpawnSettings.SpawnerData(spawnData.entityType(), spawnData.weight(), spawnData.min(), spawnData.max()));
            }
            List features = SproutConfiguredFeaturesImpl.FEATURES.get((Object)name);
            for (SproutConfiguredFeaturesImpl.FeaturePlacementData feature : features) {
                event.getGeneration().getFeatures(feature.feature()).add(feature.entry());
            }
            features = SproutConfiguredFeaturesImpl.CATEGORY_FEATURES.get((Object)event.getCategory());
            for (SproutConfiguredFeaturesImpl.FeaturePlacementData feature : features) {
                event.getGeneration().getFeatures(feature.feature()).add(feature.entry());
            }
        }
    }

    private static void entityAttributeStuff(EntityAttributeCreationEvent event) {
        event.put(SproutEntities.ELEPHANT_ENTITY_TYPE.get(), ElephantEntity.m_21552_().m_22265_());
        event.put(SproutEntities.BOUNCE_BUG_ENTITY.get(), BounceBugEntity.m_21552_().m_22265_());
    }
}

