/*
 * Decompiled with CFR 0.152.
 */
package com.toadstoolstudios.sprout.registry;

import com.toadstoolstudios.sprout.Sprout;
import com.toadstoolstudios.sprout.blocks.PeanutCrop;
import com.toadstoolstudios.sprout.registry.SproutBlocks;
import com.toadstoolstudios.sprout.registry.SproutFeatures;
import com.toadstoolstudios.sprout.registry.forge.SproutConfiguredFeaturesImpl;
import com.toadstoolstudios.sprout.world.FallenTreeFeature;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class SproutConfiguredFeatures {
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> PEANUT_PATCH = FeatureUtils.m_206488_((String)"sprout:patch_peanut", (Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)SproutBlocks.PEANUT_PLANT_BLOCK.get().m_49966_().m_61124_((Property)PeanutCrop.f_52244_, (Comparable)Integer.valueOf(2))))), List.of(Blocks.f_50440_), (int)32));
    public static final Holder<PlacedFeature> PLACED_PEANUT_PATCH = PlacementUtils.m_206513_((String)"sprout:peanut_patch_common", PEANUT_PATCH, (PlacementModifier[])new PlacementModifier[]{RarityFilter.m_191900_((int)16), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
    public static final Holder<ConfiguredFeature<SimpleRandomFeatureConfiguration, ?>> TALL_DEAD_BUSH = FeatureUtils.m_206488_((String)"sprout:tall_dead_bush", (Feature)Feature.f_65755_, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{PlacementUtils.m_206495_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)SproutBlocks.TALL_DEAD_BUSH.get())), List.of(Blocks.f_50352_, Blocks.f_49992_, Blocks.f_49993_), (int)30))})));
    public static final Holder<PlacedFeature> PLACED_TALL_DEAD_BUSH = PlacementUtils.m_206513_((String)"sprout:tall_dead_bush_common", TALL_DEAD_BUSH, (PlacementModifier[])new PlacementModifier[]{RarityFilter.m_191900_((int)16), NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)5, (int)10), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> DUNE_GRASS = FeatureUtils.m_206488_((String)"sprout:dune_grass", (Feature)Feature.f_65763_, (FeatureConfiguration)SproutConfiguredFeatures.createRandomPatchFeatureConfig((BlockStateProvider)BlockStateProvider.m_191382_((Block)SproutBlocks.DUNE_GRASS.get()), 5));
    public static final Holder<PlacedFeature> PLACED_DUNE_GRASS = PlacementUtils.m_206513_((String)"sprout:dune_grass_common", DUNE_GRASS, (PlacementModifier[])new PlacementModifier[]{NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)5, (int)10), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
    public static final Holder<ConfiguredFeature<SimpleRandomFeatureConfiguration, ?>> CATTAILS = FeatureUtils.m_206488_((String)"sprout:cattails", (Feature)Feature.f_65755_, (FeatureConfiguration)SproutConfiguredFeatures.createSingleBlockConfig(SproutBlocks.CATTIAL.get(), Blocks.f_50440_));
    public static final Holder<PlacedFeature> PLACED_CATTAILS = PlacementUtils.m_206513_((String)"sprout:cattails_common", CATTAILS, (PlacementModifier[])new PlacementModifier[]{RarityFilter.m_191900_((int)6), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> SPROUTS = FeatureUtils.m_206488_((String)"sprout:sprouts", (Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)SproutBlocks.SPROUTS.get())), List.of(Blocks.f_50440_), (int)Sprout.CONFIG.worldGen.sprouts.frequency));
    public static final Holder<PlacedFeature> PLACED_SPROUTS = PlacementUtils.m_206513_((String)"sprout:sprouts_common", SPROUTS, (PlacementModifier[])new PlacementModifier[]{NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)5, (int)10), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
    public static final Holder<ConfiguredFeature<SimpleRandomFeatureConfiguration, ?>> WATER_LENTILS = FeatureUtils.m_206488_((String)"sprout:water_lentils", (Feature)Feature.f_65755_, (FeatureConfiguration)SproutConfiguredFeatures.createSingleBlockConfig(SproutBlocks.WATER_LENTIL.get(), Blocks.f_49990_));
    public static final Holder<PlacedFeature> PLACED_WATER_LENTILS = PlacementUtils.m_206513_((String)"sprout:water_lentils_common", WATER_LENTILS, (PlacementModifier[])new PlacementModifier[]{NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)5, (int)10), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
    public static final Holder<PlacedFeature> PLACED_OAK_FALLEN_TREE = SproutConfiguredFeatures.createFallenTree(Blocks.f_49999_, 0.5f, 0.0f, 0.3f, "oak");
    public static final Holder<PlacedFeature> PLACED_OAK_MOSS_FALLEN_TREE = SproutConfiguredFeatures.createFallenTree(Blocks.f_49999_, 0.5f, 0.0f, 0.0f, "oak_moss");
    public static final Holder<PlacedFeature> PLACED_BIRCH_FALLEN_TREE = SproutConfiguredFeatures.createFallenTree(Blocks.f_50001_, 0.5f, 0.0f, 0.1f, "birch");
    public static final Holder<PlacedFeature> PLACED_DARK_OAK_FALLEN_TREE = SproutConfiguredFeatures.createFallenTree(Blocks.f_50004_, 0.5f, 0.3f, 0.3f, "dark_oak");
    public static final Holder<PlacedFeature> PLACED_SPRUCE_FALLEN_TREE = SproutConfiguredFeatures.createFallenTree(Blocks.f_50000_, 0.3f, 0.0f, 0.4f, "spruce");

    public static void registerFeatures() {
        SproutConfiguredFeatures.registerFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_PEANUT_PATCH, (ResourceKey<Biome>)Biomes.f_186754_);
        SproutConfiguredFeatures.registerFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_TALL_DEAD_BUSH, Biome.BiomeCategory.MESA);
        SproutConfiguredFeatures.registerFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_DUNE_GRASS, Biome.BiomeCategory.DESERT);
        SproutConfiguredFeatures.registerFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_CATTAILS, Biome.BiomeCategory.SWAMP);
        if (Sprout.CONFIG.worldGen.sprouts.enabled) {
            SproutConfiguredFeatures.registerFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_SPROUTS, Biome.BiomeCategory.FOREST);
            SproutConfiguredFeatures.registerFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_SPROUTS, Biome.BiomeCategory.SWAMP);
            SproutConfiguredFeatures.registerFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_SPROUTS, Biome.BiomeCategory.PLAINS);
            SproutConfiguredFeatures.registerFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_SPROUTS, Biome.BiomeCategory.TAIGA);
            SproutConfiguredFeatures.registerFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_SPROUTS, Biome.BiomeCategory.SAVANNA);
            SproutConfiguredFeatures.registerFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_SPROUTS, Biome.BiomeCategory.JUNGLE);
        }
        SproutConfiguredFeatures.registerFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_WATER_LENTILS, Biome.BiomeCategory.SWAMP);
        SproutConfiguredFeatures.registerFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_OAK_FALLEN_TREE, (ResourceKey<Biome>)Biomes.f_48205_);
        SproutConfiguredFeatures.registerFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_OAK_FALLEN_TREE, (ResourceKey<Biome>)Biomes.f_48179_);
        SproutConfiguredFeatures.registerFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_BIRCH_FALLEN_TREE, (ResourceKey<Biome>)Biomes.f_48149_);
        SproutConfiguredFeatures.registerFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_BIRCH_FALLEN_TREE, (ResourceKey<Biome>)Biomes.f_186762_);
        SproutConfiguredFeatures.registerFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_BIRCH_FALLEN_TREE, new ResourceLocation("terralith:birch_taiga"));
        SproutConfiguredFeatures.registerFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_DARK_OAK_FALLEN_TREE, (ResourceKey<Biome>)Biomes.f_48151_);
        SproutConfiguredFeatures.registerFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_SPRUCE_FALLEN_TREE, (ResourceKey<Biome>)Biomes.f_186764_);
        SproutConfiguredFeatures.registerFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_SPRUCE_FALLEN_TREE, (ResourceKey<Biome>)Biomes.f_186763_);
        SproutConfiguredFeatures.registerFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_OAK_MOSS_FALLEN_TREE, Biome.BiomeCategory.SWAMP);
    }

    private static Holder<PlacedFeature> createFallenTree(Block log, float moss, float red, float brown, String id) {
        Holder tree = FeatureUtils.m_206488_((String)("sprout:" + id + "_fallen_tree"), SproutFeatures.FALLEN_TREE.get(), (FeatureConfiguration)new FallenTreeFeature.FallenTreeConfig(log, moss, red, brown));
        return PlacementUtils.m_206513_((String)("sprout:" + id + "_fallen_tree_common"), (Holder)tree, (PlacementModifier[])new PlacementModifier[]{RarityFilter.m_191900_((int)64), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
    }

    private static SimpleRandomFeatureConfiguration createSingleBlockConfig(Block block, Block ... allowedBlocks) {
        return new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{PlacementUtils.m_206495_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206476_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)block)), List.of(allowedBlocks)))}));
    }

    private static RandomPatchConfiguration createRandomPatchFeatureConfig(BlockStateProvider block, int tries) {
        return FeatureUtils.m_206470_((int)tries, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration(block)));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerFeature(GenerationStep.Decoration feature, Holder<PlacedFeature> entry, ResourceKey<Biome> biome) {
        void var2_2;
        void var1_1;
        SproutConfiguredFeaturesImpl.registerFeature(feature, (Holder<PlacedFeature>)var1_1, (ResourceKey<Biome>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerFeature(GenerationStep.Decoration feature, Holder<PlacedFeature> entry, ResourceLocation biome) {
        void var2_2;
        void var1_1;
        SproutConfiguredFeaturesImpl.registerFeature(feature, (Holder<PlacedFeature>)var1_1, (ResourceLocation)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerFeature(GenerationStep.Decoration feature, Holder<PlacedFeature> entry, Biome.BiomeCategory category) {
        void var2_2;
        void var1_1;
        SproutConfiguredFeaturesImpl.registerFeature(feature, (Holder<PlacedFeature>)var1_1, (Biome.BiomeCategory)var2_2);
    }
}

