/*
 * Decompiled with CFR 0.152.
 */
package com.toadstoolstudios.sprout.registry;

import com.toadstoolstudios.sprout.items.BounceBugBottleItem;
import com.toadstoolstudios.sprout.items.CandyApple;
import com.toadstoolstudios.sprout.items.DrinkableFoodItem;
import com.toadstoolstudios.sprout.items.PeanutItem;
import com.toadstoolstudios.sprout.items.WaterSausage;
import com.toadstoolstudios.sprout.registry.SproutBlocks;
import com.toadstoolstudios.sprout.registry.SproutEntities;
import com.toadstoolstudios.sprout.registry.forge.SproutItemsImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.WaterLilyBlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ComposterBlock;

public class SproutItems {
    public static final Supplier<Item> ELEPHANT_SPAWN_EGG = SproutItems.registerSpawnEgg("elephant_spawn_egg", SproutEntities.ELEPHANT_ENTITY_TYPE, 8493216, 5395820, SproutItems.groupSettings(CreativeModeTab.f_40753_));
    public static final Supplier<Item> BOUNCE_BUG_SPAWN_EGG = SproutItems.registerSpawnEgg("bouncebug_spawn_egg", SproutEntities.BOUNCE_BUG_ENTITY, 45220, 12923961, SproutItems.groupSettings(CreativeModeTab.f_40753_));
    public static final Supplier<Item> BOUNCE_BUG_JAR = SproutItems.registerItem("bounce_bug_jar", () -> new BounceBugBottleItem(new Item.Properties()));
    public static final Supplier<Item> CATTIAL = SproutItems.registerItem("cattail", () -> new DoubleHighBlockItem(SproutBlocks.CATTIAL.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)));
    public static final Supplier<Item> DUNE_GRASS = SproutItems.registerItem("dune_grass", () -> new BlockItem(SproutBlocks.DUNE_GRASS.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)));
    public static final Supplier<Item> SPROUTS = SproutItems.registerItem("sprouts", () -> new BlockItem(SproutBlocks.SPROUTS.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)));
    public static final Supplier<Item> TALL_DEAD_BUSH = SproutItems.registerItem("tall_dead_bush", () -> new DoubleHighBlockItem(SproutBlocks.TALL_DEAD_BUSH.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)));
    public static final Supplier<Item> WATER_LENTIL = SproutItems.registerItem("water_lentil", () -> new WaterLilyBlockItem(SproutBlocks.WATER_LENTIL.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)));
    public static final Supplier<Item> PEANUT = SproutItems.registerItem("peanut", () -> new PeanutItem(SproutBlocks.PEANUT_PLANT_BLOCK.get(), SproutItems.groupSettings(CreativeModeTab.f_40755_).m_41489_(Foods.f_38808_)));
    public static final Supplier<Item> PEANUT_BUTTER = SproutItems.registerItem("peanut_butter", DrinkableFoodItem::new);
    public static final Supplier<Item> PBJ = SproutItems.registerItem("pbj", () -> new Item(SproutItems.groupSettings(CreativeModeTab.f_40755_).m_41489_(Foods.f_38824_)));
    public static final Supplier<Item> PEANUT_BUTTER_COOKIE = SproutItems.registerItem("peanut_butter_cookie", () -> new Item(SproutItems.groupSettings(CreativeModeTab.f_40755_).m_41489_(Foods.f_38827_)));
    public static final Supplier<Item> GLOW_BERRY_JAM = SproutItems.registerItem("glow_berry_jam", DrinkableFoodItem::new);
    public static final Supplier<Item> GLOW_BERRY_PIE = SproutItems.registerItem("glow_berry_pie", () -> new Item(SproutItems.groupSettings(CreativeModeTab.f_40755_).m_41489_(Foods.f_38801_)));
    public static final Supplier<Item> SWEET_BERRY_JAM = SproutItems.registerItem("sweet_berry_jam", DrinkableFoodItem::new);
    public static final Supplier<Item> SWEET_BERRY_PIE = SproutItems.registerItem("sweet_berry_pie", () -> new Item(SproutItems.groupSettings(CreativeModeTab.f_40755_).m_41489_(Foods.f_38801_)));
    public static final Supplier<Item> APPLE_PIE = SproutItems.registerItem("apple_pie", () -> new Item(SproutItems.groupSettings(CreativeModeTab.f_40755_).m_41489_(Foods.f_38801_)));
    public static final Supplier<Item> BUTTERSCOTCH = SproutItems.registerItem("butterscotch", () -> new Item(SproutItems.groupSettings(CreativeModeTab.f_40755_).m_41489_(Foods.f_38808_)));
    public static final Supplier<Item> CANDY_APPLE = SproutItems.registerItem("candy_apple", () -> new CandyApple(SproutItems.groupSettings(CreativeModeTab.f_40755_).m_41489_(Foods.f_38811_)));
    public static final FoodProperties GOLDEN_APPLE_CANDY = new FoodProperties.Builder().m_38760_(8).m_38758_(2.0f).m_38762_(new MobEffectInstance(MobEffects.f_19605_, 100, 1), 1.0f).m_38762_(new MobEffectInstance(MobEffects.f_19617_, 2400, 0), 1.0f).m_38765_().m_38767_();
    public static final Supplier<Item> GOLDEN_CANDY_APPLE = SproutItems.registerItem("golden_candy_apple", () -> new CandyApple(SproutItems.groupSettings(CreativeModeTab.f_40755_).m_41489_(GOLDEN_APPLE_CANDY)));
    public static final Supplier<Item> WATER_SAUSAGE = SproutItems.registerItem("water_sausage", () -> new WaterSausage(SproutItems.groupSettings(CreativeModeTab.f_40755_).m_41489_(Foods.f_38819_)));

    public static void onComplete() {
        Object2FloatMap compostMap = ComposterBlock.f_51914_;
        compostMap.put((Object)((ItemLike)PEANUT.get()), 0.3f);
        compostMap.put((Object)((ItemLike)BUTTERSCOTCH.get()), 0.65f);
        compostMap.put((Object)((ItemLike)PBJ.get()), 0.85f);
        compostMap.put((Object)((ItemLike)PEANUT_BUTTER_COOKIE.get()), 0.85f);
        compostMap.put((Object)((ItemLike)CANDY_APPLE.get()), 0.85f);
        compostMap.put((Object)((ItemLike)GLOW_BERRY_PIE.get()), 1.0f);
        compostMap.put((Object)((ItemLike)SWEET_BERRY_PIE.get()), 1.0f);
        compostMap.put((Object)((ItemLike)APPLE_PIE.get()), 1.0f);
        compostMap.put((Object)((ItemLike)GOLDEN_CANDY_APPLE.get()), 1.0f);
        compostMap.put((Object)((ItemLike)WATER_SAUSAGE.get()), 1.0f);
    }

    private static Item.Properties groupSettings(CreativeModeTab group) {
        return new Item.Properties().m_41491_(group);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Supplier<Item> registerItem(String name, Supplier<Item> itemSupplier) {
        void var1_1;
        return SproutItemsImpl.registerItem(name, (Supplier<Item>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Supplier<Item> registerSpawnEgg(String name, Supplier<? extends EntityType<? extends Mob>> entityTypeSupplier, int primaryColor, int secondaryColor, Item.Properties settings) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return SproutItemsImpl.registerSpawnEgg(name, (Supplier<? extends EntityType<? extends Mob>>)var1_1, (int)var2_2, (int)var3_3, (Item.Properties)var4_4);
    }

    public static void registerItems() {
    }
}

