/*
 * Decompiled with CFR 0.152.
 */
package com.toadstoolstudios.sprout.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.toadstoolstudios.sprout.registry.SproutBlocks;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class FallenTreeFeature
extends Feature<FallenTreeConfig> {
    private static final int[] DIR = new int[]{-1, 1};
    private static final int[] DIR_REVERSED = new int[]{1, -1};

    public FallenTreeFeature(Codec<FallenTreeConfig> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<FallenTreeConfig> context) {
        Random random = context.m_159776_();
        BlockPos pos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        Direction.Axis axis = Direction.Plane.HORIZONTAL.m_122560_(random).m_122434_();
        ArrayList<BlockPos> validPosInLine = new ArrayList<BlockPos>(5);
        int count = 0;
        for (int i = 0; i < 5; ++i) {
            BlockPos offset = pos.m_142629_(axis, i);
            if (!level.m_8055_(offset).m_60767_().m_76336_() || level.m_8055_(offset.m_7495_()).m_60767_().m_76336_()) {
                count = 0;
                continue;
            }
            validPosInLine.add(offset);
            ++count;
        }
        if (count < 3) {
            return false;
        }
        BlockState state = ((FallenTreeConfig)context.m_159778_()).log().m_49966_();
        if (state.m_61138_((Property)BlockStateProperties.f_61365_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)axis);
        }
        Direction.Axis oppositeAxis = FallenTreeFeature.opposite(axis);
        for (BlockPos blockPos : validPosInLine) {
            if (!level.m_7731_(blockPos, state, 3)) continue;
            FallenTreeFeature.place(random, blockPos, oppositeAxis, level, (FallenTreeConfig)context.m_159778_());
        }
        return true;
    }

    private static void place(Random random, BlockPos pos, Direction.Axis axis, WorldGenLevel level, FallenTreeConfig config) {
        float red = config.redMushroom();
        float brown = config.brownMushroom();
        if (random.nextFloat() < config.moss() && level.m_46859_(pos.m_7494_())) {
            level.m_7731_(pos.m_7494_(), Blocks.f_152543_.m_49966_(), 3);
            red /= 2.0f;
            brown /= 2.0f;
        }
        boolean placeRed = true;
        if (random.nextFloat() < brown && FallenTreeFeature.place(random, pos, axis, level, SproutBlocks.BROWN_SHELF_FUNGI.get().m_49966_())) {
            placeRed = false;
        }
        if (placeRed && random.nextFloat() < red) {
            FallenTreeFeature.place(random, pos, axis, level, SproutBlocks.RED_SHELF_FUNGI.get().m_49966_());
        }
    }

    private static Direction.Axis opposite(Direction.Axis axis) {
        return axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
    }

    private static boolean place(Random random, BlockPos pos, Direction.Axis axis, WorldGenLevel level, BlockState state) {
        for (int i : random.nextBoolean() ? DIR_REVERSED : DIR) {
            if (state.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
                state = (BlockState)state.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)(i > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE)));
            }
            if (!level.m_8055_(pos.m_142629_(axis, i)).m_60767_().m_76336_() || !level.m_7731_(pos.m_142629_(axis, i), state, 3)) continue;
            return true;
        }
        return false;
    }

    public record FallenTreeConfig(Block log, float moss, float redMushroom, float brownMushroom) implements FeatureConfiguration
    {
        public static final Codec<FallenTreeConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.f_122824_.m_194605_().fieldOf("log").forGetter(FallenTreeConfig::log), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("moss").orElse((Object)Float.valueOf(0.0f)).forGetter(FallenTreeConfig::moss), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("redMushroom").orElse((Object)Float.valueOf(0.0f)).forGetter(FallenTreeConfig::redMushroom), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("brownMushroom").orElse((Object)Float.valueOf(0.0f)).forGetter(FallenTreeConfig::brownMushroom)).apply((Applicative)instance, FallenTreeConfig::new));
    }
}

