/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.data.tempad_options;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import me.codexadrian.tempad.TempadType;
import me.codexadrian.tempad.data.tempad_options.TempadOption;
import me.codexadrian.tempad.utils.ConfigUtils;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class TimerOption
extends TempadOption {
    public static final TimerOption NORMAL_INSTANCE = new TimerOption(TempadType.NORMAL);
    public static final TimerOption ADVANCED_INSTANCE = new TimerOption(TempadType.HE_WHO_REMAINS);

    protected TimerOption(TempadType type) {
        super(type);
    }

    @Override
    public boolean canTimedoorOpen(class_1657 player, class_1799 stack) {
        if (stack.method_7969() != null && stack.method_7969().method_10545("timer")) {
            long cooldownTimeTag = stack.method_7969().method_10537("timer");
            Instant cooldownTime = Instant.ofEpochSecond(cooldownTimeTag);
            return Instant.now().isAfter(cooldownTime);
        }
        return true;
    }

    @Override
    public void onTimedoorOpen(class_1657 player, class_1799 stack) {
        stack.method_7948().method_10544("timer", Instant.now().plusSeconds(ConfigUtils.getOptionConfig(this.getType()).getCooldownTime()).getEpochSecond());
    }

    @Override
    public void addToolTip(class_1799 stack, class_1937 level, List<class_2561> components, class_1836 flag) {
        long cooldown = TimerOption.timeLeft(stack);
        if (cooldown > 0L) {
            components.add((class_2561)new class_2588("tooltip.tempad.timeleft").method_27693(DurationFormatUtils.formatDuration((long)cooldown, (String)"mm:ss", (boolean)true)));
        } else {
            components.add((class_2561)new class_2588("tooltip.tempad.fullycharged", new Object[]{DurationFormatUtils.formatDuration((long)((long)ConfigUtils.getOptionConfig(this.getType()).getCooldownTime() * 1000L), (String)"mm:ss", (boolean)false)}));
        }
    }

    @Override
    public boolean isDurabilityBarVisible(class_1799 stack) {
        return !this.canTimedoorOpen(null, stack);
    }

    @Override
    public int durabilityBarWidth(class_1799 stack) {
        double maxTime = (double)ConfigUtils.getOptionConfig(this.getType()).getCooldownTime() * 1000.0;
        return (int)((double)((float)(maxTime - (double)TimerOption.timeLeft(stack))) / maxTime * 13.0);
    }

    public static long timeLeft(class_1799 stack) {
        if (stack.method_7969() != null && stack.method_7969().method_10545("timer")) {
            long cooldownTimeTag = stack.method_7969().method_10537("timer");
            Instant cooldownTime = Instant.ofEpochSecond(cooldownTimeTag);
            return Instant.now().until(cooldownTime, ChronoUnit.MILLIS);
        }
        return 0L;
    }

    public static long getTimerNBT(class_1799 stack) {
        if (stack.method_7969() != null && stack.method_7969().method_10545("timer")) {
            return stack.method_7969().method_10537("timer");
        }
        return 0L;
    }
}

