/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.data.tempad_options;

import java.util.List;
import me.codexadrian.tempad.TempadType;
import me.codexadrian.tempad.data.tempad_options.TempadOption;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Range;

public class DurabilityOption
extends TempadOption {
    public static final DurabilityOption NORMAL_INSTANCE = new DurabilityOption(TempadType.NORMAL);
    public static final DurabilityOption ADVANCED_INSTANCE = new DurabilityOption(TempadType.HE_WHO_REMAINS);

    protected DurabilityOption(TempadType type) {
        super(type);
    }

    @Override
    public boolean canTimedoorOpen(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public void onTimedoorOpen(Player player, InteractionHand hand) {
        player.m_21120_(hand).m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(hand));
    }

    @Override
    public void addToolTip(ItemStack stack, Level level, List<Component> components, TooltipFlag flag) {
        components.add((Component)new TranslatableComponent("tooltip.tempad.durability_cost", new Object[]{this.getType().durability - stack.m_41773_(), this.getType().durability}));
    }

    @Override
    public boolean isDurabilityBarVisible(ItemStack stack) {
        return stack.m_41768_();
    }

    @Override
    public @Range(from=0L, to=13L) int durabilityBarWidth(ItemStack stack) {
        return Math.round(13.0f - (float)stack.m_41773_() * 13.0f / 100.0f);
    }
}

