/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.data.tempad_options;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import me.codexadrian.tempad.TempadType;
import me.codexadrian.tempad.data.tempad_options.TempadOption;
import me.codexadrian.tempad.utils.ConfigUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class TimerOption
extends TempadOption {
    public static final TimerOption NORMAL_INSTANCE = new TimerOption(TempadType.NORMAL);
    public static final TimerOption ADVANCED_INSTANCE = new TimerOption(TempadType.HE_WHO_REMAINS);

    protected TimerOption(TempadType type) {
        super(type);
    }

    @Override
    public boolean canTimedoorOpen(Player player, ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("timer")) {
            long cooldownTimeTag = stack.m_41783_().m_128454_("timer");
            Instant cooldownTime = Instant.ofEpochSecond(cooldownTimeTag);
            return Instant.now().isAfter(cooldownTime);
        }
        return true;
    }

    @Override
    public void onTimedoorOpen(Player player, ItemStack stack) {
        stack.m_41784_().m_128356_("timer", Instant.now().plusSeconds(ConfigUtils.getOptionConfig(this.getType()).getCooldownTime()).getEpochSecond());
    }

    @Override
    public void addToolTip(ItemStack stack, Level level, List<Component> components, TooltipFlag flag) {
        long cooldown = TimerOption.timeLeft(stack);
        if (cooldown > 0L) {
            components.add((Component)new TranslatableComponent("tooltip.tempad.timeleft").m_130946_(DurationFormatUtils.formatDuration((long)cooldown, (String)"mm:ss", (boolean)true)));
        } else {
            components.add((Component)new TranslatableComponent("tooltip.tempad.fullycharged", new Object[]{DurationFormatUtils.formatDuration((long)((long)ConfigUtils.getOptionConfig(this.getType()).getCooldownTime() * 1000L), (String)"mm:ss", (boolean)false)}));
        }
    }

    @Override
    public boolean isDurabilityBarVisible(ItemStack stack) {
        return !this.canTimedoorOpen(null, stack);
    }

    @Override
    public int durabilityBarWidth(ItemStack stack) {
        double maxTime = (double)ConfigUtils.getOptionConfig(this.getType()).getCooldownTime() * 1000.0;
        return (int)((double)((float)(maxTime - (double)TimerOption.timeLeft(stack))) / maxTime * 13.0);
    }

    public static long timeLeft(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("timer")) {
            long cooldownTimeTag = stack.m_41783_().m_128454_("timer");
            Instant cooldownTime = Instant.ofEpochSecond(cooldownTimeTag);
            return Instant.now().until(cooldownTime, ChronoUnit.MILLIS);
        }
        return 0L;
    }

    public static long getTimerNBT(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("timer")) {
            return stack.m_41783_().m_128454_("timer");
        }
        return 0L;
    }
}

