/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.platform;

import java.util.ServiceLoader;
import me.codexadrian.tempad.Constants;
import me.codexadrian.tempad.platform.services.INetworkHelper;
import me.codexadrian.tempad.platform.services.IPlatformHelper;
import me.codexadrian.tempad.platform.services.IRegistryHelper;
import me.codexadrian.tempad.platform.services.IShaderHelper;

public class Services {
    public static final IPlatformHelper PLATFORM = Services.load(IPlatformHelper.class);
    public static final INetworkHelper NETWORK = Services.load(INetworkHelper.class);
    public static final IRegistryHelper REGISTRY = Services.load(IRegistryHelper.class);
    public static final IShaderHelper SHADERS = Services.load(IShaderHelper.class);

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        Constants.LOG.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

