/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.codexadrian.tempad.client.gui.NewLocationScreen;
import me.codexadrian.tempad.client.widgets.TextButton;
import me.codexadrian.tempad.client.widgets.TimedoorSprite;
import me.codexadrian.tempad.data.LocationData;
import me.codexadrian.tempad.data.TempadComponent;
import me.codexadrian.tempad.data.tempad_options.TimerOption;
import me.codexadrian.tempad.network.messages.DeleteLocationPacket;
import me.codexadrian.tempad.network.messages.SummonTimedoorPacket;
import me.codexadrian.tempad.platform.Services;
import me.codexadrian.tempad.tempad.TempadItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class RunProgramScreen
extends Screen {
    private static final ResourceLocation GRID = new ResourceLocation("tempad", "textures/widget/tempad_grid.png");
    private final int color;
    private static final int WIDTH = 480;
    private static final int HEIGHT = 256;
    private int mouseMovement;
    private int listSize;
    private final InteractionHand hand;
    private boolean interfaceNeedsReload = false;
    private boolean listNeedsReload = false;
    private final TimedoorSprite timedoorSprite;
    private List<LocationData> allLocations;
    private List<TextButton> displayedLocations;
    private final List<Button> displayedInterfaceButtons = new ArrayList<Button>();
    private final List<Button> upNextButtons = new ArrayList<Button>();

    public RunProgramScreen(int color, InteractionHand hand) {
        super(Component.m_130674_((String)""));
        this.color = color;
        this.hand = hand;
        this.timedoorSprite = new TimedoorSprite(0, 0, color, 144);
        this.allLocations = new ArrayList<LocationData>();
        this.displayedLocations = new ArrayList<TextButton>();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int wiggleRoom = this.listSize > 12 ? this.listSize - 12 : 0;
        this.mouseMovement = Math.min(wiggleRoom, Math.max(this.mouseMovement + (int)(delta * 10.0), 0));
        if (this.listSize > 12) {
            this.listNeedsReload = true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    protected void m_7856_() {
        super.m_7856_();
        int offset = 3;
        this.timedoorSprite.changePosition((this.f_96543_ - 480) / 2 + 48, (this.f_96544_ - 256) / 2 + offset + 32);
        ItemStack stack = this.f_96541_.f_91074_.m_21120_(this.hand);
        if (stack.m_41782_()) {
            this.allLocations = new ArrayList<LocationData>(TempadComponent.fromStack(stack).getLocations());
            this.listSize = this.allLocations.size();
            List<Object> shownLocationData = new ArrayList();
            if (this.listSize > 12) {
                for (int i = 0; i < 12; ++i) {
                    shownLocationData.add(this.allLocations.get(i));
                }
            } else {
                shownLocationData = this.allLocations;
            }
            int x = (this.f_96543_ - 480) / 2 + offset + 240;
            int y = (this.f_96544_ - 256) / 2 + offset + 32;
            Collections.sort(shownLocationData);
            for (LocationData locationData : shownLocationData) {
                TextButton locationButton = new TextButton(x, y, 12, (Component)Component.m_237113_((String)locationData.getName()), this.color, button -> this.locationButtonOnPress(data));
                this.displayedLocations.add(locationButton);
                this.m_142416_((GuiEventListener)locationButton);
                y += 16;
            }
        }
        TextButton addLocation = new TextButton((this.f_96543_ - 480) / 2 + offset + 240, (this.f_96544_ - 256) / 2 + offset + 224, 12, (Component)Component.m_237115_((String)"gui.tempad.new_location"), this.color, button -> this.f_96541_.m_91152_((Screen)new NewLocationScreen(this.color, this.hand)));
        this.m_142416_((GuiEventListener)addLocation);
    }

    private void locationButtonOnPress(LocationData data) {
        long timerTime;
        TempadItem item;
        String locationName = data.getBlockPos().m_123344_();
        TextButton displayedLocation = new TextButton((this.f_96543_ - 480) / 2 + 128 - (int)((double)this.f_96547_.m_92895_(locationName) * 0.75) - 8, (this.f_96544_ - 256) / 2 + 3 + 176, 12, (Component)Component.m_237113_((String)locationName), this.color, button1 -> {});
        MutableComponent teleportText = Component.m_237115_((String)"gui.tempad.teleport");
        Instant timeUntilUsable = null;
        ItemStack itemInHand = this.f_96541_.f_91074_.m_21120_(this.hand);
        Item item2 = itemInHand.m_41720_();
        if (item2 instanceof TempadItem && (item = (TempadItem)item2).getOption() instanceof TimerOption && (timerTime = TimerOption.getTimerNBT(itemInHand)) > 0L) {
            timeUntilUsable = Instant.now().plusMillis(timerTime);
        }
        TextButton teleportButton = new TextButton((this.f_96543_ - 480) / 2 + 128 - (int)((double)this.f_96547_.m_92852_((FormattedText)teleportText) * 0.75) - 8, (this.f_96544_ - 256) / 2 + 3 + 192, 12, (Component)teleportText, this.color, button2 -> this.teleportAction(data), timeUntilUsable);
        MutableComponent deleteText = Component.m_237115_((String)"gui.tempad.delete");
        TextButton deleteLocationButton = new TextButton((this.f_96543_ - 480) / 2 + 128 - (int)((double)this.f_96547_.m_92852_((FormattedText)deleteText) * 0.75) - 8, (this.f_96544_ - 256) / 2 + 3 + 208, 12, (Component)deleteText, this.color, button2 -> {
            Minecraft.m_91087_().m_91152_(null);
            Services.NETWORK.sendToServer(new DeleteLocationPacket(data.getId(), this.hand));
        });
        this.upNextButtons.add(displayedLocation);
        this.upNextButtons.add(teleportButton);
        this.upNextButtons.add(deleteLocationButton);
        this.interfaceNeedsReload = true;
    }

    private void teleportAction(LocationData data) {
        TempadItem tempadItem;
        Item item;
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        ItemStack itemInHand = this.f_96541_.f_91074_.m_21120_(this.hand);
        if (itemInHand.m_41782_() && (item = itemInHand.m_41720_()) instanceof TempadItem && (tempadItem = (TempadItem)item).getOption().canTimedoorOpen((Player)this.f_96541_.f_91074_, itemInHand)) {
            Minecraft.m_91087_().m_91152_(null);
            Services.NETWORK.sendToServer(new SummonTimedoorPacket(data.getLevelKey().m_135782_(), data.getBlockPos(), this.hand, this.color));
        }
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.interfaceNeedsReload) {
            this.displayedInterfaceButtons.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
            this.displayedInterfaceButtons.clear();
            this.displayedInterfaceButtons.addAll(this.upNextButtons);
            this.upNextButtons.clear();
            this.displayedInterfaceButtons.forEach(x$0 -> {
                Button cfr_ignored_0 = (Button)this.m_142416_((GuiEventListener)x$0);
            });
            this.m_169411_(this.timedoorSprite);
            this.m_142416_(this.timedoorSprite);
            this.interfaceNeedsReload = false;
        }
        int x = (this.f_96543_ - 480) / 2 + 3 + 240;
        int y = (this.f_96544_ - 256) / 2 + 3 + 32;
        if (this.listNeedsReload) {
            int offset;
            for (TextButton button2 : this.displayedLocations) {
                this.m_169411_((GuiEventListener)button2);
            }
            this.displayedLocations = new ArrayList<TextButton>();
            for (int i = offset = Math.min(this.mouseMovement, this.listSize - 12); i < 12 + offset; ++i) {
                LocationData data = this.allLocations.get(i);
                this.displayedLocations.add(new TextButton(x, y, 12, (Component)Component.m_237113_((String)data.getName()), this.color, button -> this.locationButtonOnPress(data)));
                y += 16;
            }
            this.displayedLocations.forEach(x$0 -> {
                TextButton cfr_ignored_0 = (TextButton)this.m_142416_((GuiEventListener)x$0);
            });
            this.listNeedsReload = false;
        }
    }

    private void renderOutline(PoseStack poseStack) {
        int lineWidth = 4;
        RunProgramScreen.m_93172_((PoseStack)poseStack, (int)((this.f_96543_ - 480 - lineWidth) / 2), (int)((this.f_96544_ - 256 - lineWidth) / 2), (int)((this.f_96543_ + 480 + lineWidth) / 2), (int)((this.f_96544_ + 256 + lineWidth) / 2), (int)(this.color | 0xFF000000));
    }

    private void renderGridBackground(PoseStack poseStack, float red, float green, float blue) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)GRID);
        RenderSystem.m_157429_((float)(red * 0.5f), (float)(green * 0.5f), (float)(blue * 0.5f), (float)1.0f);
        RunProgramScreen.m_93160_((PoseStack)poseStack, (int)((this.f_96543_ - 480) / 2), (int)((this.f_96544_ - 256) / 2), (int)480, (int)256, (float)0.0f, (float)0.0f, (int)480, (int)256, (int)16, (int)16);
    }

    public void m_96558_(PoseStack poseStack, int offset) {
        super.m_96558_(poseStack, offset);
        float red = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.color & 0xFF) / 255.0f;
        this.renderOutline(poseStack);
        this.renderGridBackground(poseStack, red, green, blue);
        this.renderHeaders(poseStack);
    }

    private void renderHeaders(PoseStack matrices) {
        Font font = this.f_96541_.f_91062_;
        int cornerX = (this.f_96543_ - 480) / 2 + 3;
        int cornerY = (this.f_96544_ - 256) / 2 + 3;
        int x = cornerX + 240;
        int y = cornerY + 16;
        matrices.m_85836_();
        matrices.m_85837_((double)x * -0.5, (double)y * -0.5, 0.0);
        matrices.m_85841_(1.5f, 1.5f, 0.0f);
        RunProgramScreen.m_93243_((PoseStack)matrices, (Font)font, (Component)Component.m_237115_((String)"gui.tempad.select_location"), (int)x, (int)y, (int)this.color);
        matrices.m_85849_();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_7043_() {
        return false;
    }
}

