/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.client.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.AbstractUniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Comparator;
import java.util.stream.StreamSupport;
import me.codexadrian.tempad.entity.TimedoorEntity;
import me.codexadrian.tempad.platform.Services;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class TimedoorBlurRenderer {
    public static void renderBlur(float deltaTime, PoseStack poseStack, Camera camera) {
        Minecraft minecraft = Minecraft.m_91087_();
        RenderTarget renderTexture = minecraft.m_91385_();
        RenderTarget blurRenderTarget = Services.SHADERS.getBlurReloader().getRenderTarget();
        if (blurRenderTarget == null) {
            return;
        }
        TimedoorBlurRenderer.clear(blurRenderTarget);
        blurRenderTarget.m_83945_(renderTexture);
        renderTexture.m_83947_(false);
        Vec3 position = camera.m_90583_();
        double cameraX = position.m_7096_();
        double cameraY = position.m_7098_();
        double cameraZ = position.m_7094_();
        AbstractUniform inSize = Services.SHADERS.getTimedoorShader().m_173356_("InSize");
        AbstractUniform viewMatUniform = Services.SHADERS.getTimedoorShader().m_173356_("ViewMat");
        PoseStack viewMat = new PoseStack();
        viewMat.m_85845_(Vector3f.f_122223_.m_122240_(camera.m_90589_()));
        viewMat.m_85845_(Vector3f.f_122225_.m_122240_(camera.m_90590_() + 180.0f));
        viewMatUniform.m_5679_(viewMat.m_85850_().m_85861_());
        inSize.m_7971_((float)renderTexture.f_83915_, (float)renderTexture.f_83916_);
        assert (minecraft.f_91073_ != null);
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        StreamSupport.stream(minecraft.f_91073_.m_104735_().spliterator(), false).filter(TimedoorEntity.class::isInstance).sorted(Comparator.comparingDouble(value -> -value.m_20280_(minecraft.f_91075_))).forEach(entity -> {
            double entityX = Mth.m_14139_((double)deltaTime, (double)entity.f_19790_, (double)entity.m_20185_());
            double entityY = Mth.m_14139_((double)deltaTime, (double)entity.f_19791_, (double)entity.m_20186_());
            double entityZ = Mth.m_14139_((double)deltaTime, (double)entity.f_19792_, (double)entity.m_20189_());
            float entityYaw = Mth.m_14179_((float)deltaTime, (float)entity.f_19859_, (float)entity.m_146908_());
            blurRenderTarget.m_83947_(false);
            minecraft.m_91290_().m_114384_(entity, entityX - cameraX, entityY - cameraY, entityZ - cameraZ, entityYaw, deltaTime, poseStack, (MultiBufferSource)bufferSource, minecraft.m_91290_().m_114394_(entity, deltaTime));
            bufferSource.m_173043_();
            renderTexture.m_83947_(false);
        });
        RenderSystem.m_69890_(() -> Services.SHADERS.getBlurReloader().getTimedoorBlur().m_110023_(deltaTime));
        renderTexture.m_83947_(false);
    }

    public static void bindAll(RenderTarget renderTarget) {
        GlStateManager.m_84486_((int)36160, (int)renderTarget.f_83920_);
    }

    public static void clear(RenderTarget renderTarget) {
        TimedoorBlurRenderer.bindAll(renderTarget);
        GlStateManager.m_84266_((int)16384, (boolean)false);
        GlStateManager.m_84318_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.m_84486_((int)36160, (int)0);
    }
}

