/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.codexadrian.tempad.Constants;

public class TempadConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    @SerializedName(value="cooldownTimeInSeconds")
    private int cooldownTime = 180;
    @SerializedName(value="timedoorPlacementOffsetInBlocks")
    private int distanceFromPlayer = 3;
    @SerializedName(value="timedoorCloseWaitingTimeInTicks")
    private int timedoorWait = 60;
    @SerializedName(value="onEntityThroughDoorAdditionalTimeInTicks")
    private int timedoorAddWaitTime = 40;

    public int getCooldownTime() {
        return this.cooldownTime;
    }

    public int getDistanceFromPlayer() {
        return this.distanceFromPlayer;
    }

    public int getTimedoorAddWaitTime() {
        return this.timedoorAddWaitTime;
    }

    public int getTimedoorWait() {
        return this.timedoorWait;
    }

    public static TempadConfig loadConfig(Path configFolder) throws IOException {
        Path configPath = configFolder.resolve("tempad.json");
        if (!Files.exists(configPath, new LinkOption[0])) {
            TempadConfig config = new TempadConfig();
            try (FileWriter writer = new FileWriter(configPath.toFile());){
                GSON.toJson((Object)config, (Appendable)writer);
            }
            Constants.LOG.info("Created config file for mod tempad");
            return config;
        }
        return (TempadConfig)GSON.fromJson((Reader)new InputStreamReader(Files.newInputStream(configPath, new OpenOption[0])), TempadConfig.class);
    }
}

