/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.codexadrian.tempad.client.gui.NewLocationScreen;
import me.codexadrian.tempad.client.widgets.TextButton;
import me.codexadrian.tempad.client.widgets.TimedoorSprite;
import me.codexadrian.tempad.network.messages.DeleteLocationPacket;
import me.codexadrian.tempad.network.messages.SummonTimedoorPacket;
import me.codexadrian.tempad.platform.Services;
import me.codexadrian.tempad.tempad.LocationData;
import me.codexadrian.tempad.tempad.TempadComponent;
import me.codexadrian.tempad.tempad.TempadItem;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class RunProgramScreen
extends class_437 {
    private static final class_2960 GRID = new class_2960("tempad", "textures/widget/tempad_grid.png");
    private final int color;
    private static final int WIDTH = 480;
    private static final int HEIGHT = 256;
    private int mouseMovement;
    private int listSize;
    private final class_1268 hand;
    private boolean interfaceNeedsReload = false;
    private boolean listNeedsReload = false;
    private final TimedoorSprite timedoorSprite;
    private List<LocationData> allLocations;
    private List<TextButton> displayedLocations;
    private final List<class_4185> displayedInterfaceButtons = new ArrayList<class_4185>();
    private final List<class_4185> upNextButtons = new ArrayList<class_4185>();

    public RunProgramScreen(int color, class_1268 hand) {
        super(class_2561.method_30163((String)""));
        this.color = color;
        this.hand = hand;
        this.timedoorSprite = new TimedoorSprite(0, 0, color, 144);
        this.allLocations = new ArrayList<LocationData>();
        this.displayedLocations = new ArrayList<TextButton>();
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int wiggleRoom = this.listSize > 12 ? this.listSize - 12 : 0;
        this.mouseMovement = Math.min(wiggleRoom, Math.max(this.mouseMovement + (int)(delta * 10.0), 0));
        if (this.listSize > 12) {
            this.listNeedsReload = true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    protected void method_25426() {
        super.method_25426();
        int offset = 3;
        this.timedoorSprite.changePosition((this.field_22789 - 480) / 2 + 48, (this.field_22790 - 256) / 2 + offset + 32);
        class_1799 stack = this.field_22787.field_1724.method_5998(this.hand);
        if (stack.method_7985()) {
            this.allLocations = new ArrayList<LocationData>(TempadComponent.fromStack(stack).getLocations());
            this.listSize = this.allLocations.size();
            List<Object> shownLocationData = new ArrayList();
            if (this.listSize > 12) {
                for (int i = 0; i < 12; ++i) {
                    shownLocationData.add(this.allLocations.get(i));
                }
            } else {
                shownLocationData = this.allLocations;
            }
            int x = (this.field_22789 - 480) / 2 + offset + 240;
            int y = (this.field_22790 - 256) / 2 + offset + 32;
            Collections.sort(shownLocationData);
            for (LocationData locationData : shownLocationData) {
                TextButton locationButton = new TextButton(x, y, 12, (class_2561)class_2561.method_43470((String)locationData.getName()), this.color, button -> this.locationButtonOnPress(data));
                this.displayedLocations.add(locationButton);
                this.method_37063((class_364)locationButton);
                y += 16;
            }
        }
        TextButton addLocation = new TextButton((this.field_22789 - 480) / 2 + offset + 240, (this.field_22790 - 256) / 2 + offset + 224, 12, (class_2561)class_2561.method_43471((String)"gui.tempad.new_location"), this.color, button -> this.field_22787.method_1507((class_437)new NewLocationScreen(this.color, this.hand)));
        this.method_37063((class_364)addLocation);
    }

    private void locationButtonOnPress(LocationData data) {
        String locationName = data.getBlockPos().method_23854();
        TextButton displayedLocation = new TextButton((this.field_22789 - 480) / 2 + 128 - (int)((double)this.field_22793.method_1727(locationName) * 0.75) - 8, (this.field_22790 - 256) / 2 + 3 + 176, 12, (class_2561)class_2561.method_43470((String)locationName), this.color, button1 -> {});
        class_5250 teleportText = class_2561.method_43471((String)"gui.tempad.teleport");
        Instant timeUntilUsable = null;
        class_1799 itemInHand = this.field_22787.field_1724.method_5998(this.hand);
        if (itemInHand.method_7985() && itemInHand.method_7969().method_10545("timer")) {
            timeUntilUsable = Instant.ofEpochSecond(itemInHand.method_7969().method_10537("timer"));
        }
        TextButton teleportButton = new TextButton((this.field_22789 - 480) / 2 + 128 - (int)((double)this.field_22793.method_27525((class_5348)teleportText) * 0.75) - 8, (this.field_22790 - 256) / 2 + 3 + 192, 12, (class_2561)teleportText, this.color, button2 -> this.teleportAction(data), timeUntilUsable);
        class_5250 deleteText = class_2561.method_43471((String)"gui.tempad.delete");
        TextButton deleteLocationButton = new TextButton((this.field_22789 - 480) / 2 + 128 - (int)((double)this.field_22793.method_27525((class_5348)deleteText) * 0.75) - 8, (this.field_22790 - 256) / 2 + 3 + 208, 12, (class_2561)deleteText, this.color, button2 -> {
            class_310.method_1551().method_1507(null);
            Services.NETWORK.sendToServer(new DeleteLocationPacket(data.getId(), this.hand));
        });
        this.upNextButtons.add(displayedLocation);
        this.upNextButtons.add(teleportButton);
        this.upNextButtons.add(deleteLocationButton);
        this.interfaceNeedsReload = true;
    }

    private void teleportAction(LocationData data) {
        TempadItem tempadItem;
        class_1792 class_17922;
        class_1799 itemInHand = this.field_22787.field_1724.method_5998(this.hand);
        if (itemInHand.method_7985() && (class_17922 = itemInHand.method_7909()) instanceof TempadItem && (tempadItem = (TempadItem)class_17922).checkIfUsable(itemInHand)) {
            class_310.method_1551().method_1507(null);
            Services.NETWORK.sendToServer(new SummonTimedoorPacket(data.getLevelKey().method_29177(), data.getBlockPos(), this.hand, this.color));
        }
    }

    public void method_25393() {
        super.method_25393();
        if (this.interfaceNeedsReload) {
            this.displayedInterfaceButtons.forEach(x$0 -> this.method_37066((class_364)x$0));
            this.displayedInterfaceButtons.clear();
            this.displayedInterfaceButtons.addAll(this.upNextButtons);
            this.upNextButtons.clear();
            this.displayedInterfaceButtons.forEach(x$0 -> {
                class_4185 cfr_ignored_0 = (class_4185)this.method_37063((class_364)x$0);
            });
            this.method_37066(this.timedoorSprite);
            this.method_37063(this.timedoorSprite);
            this.interfaceNeedsReload = false;
        }
        int x = (this.field_22789 - 480) / 2 + 3 + 240;
        int y = (this.field_22790 - 256) / 2 + 3 + 32;
        if (this.listNeedsReload) {
            int offset;
            for (TextButton button2 : this.displayedLocations) {
                this.method_37066((class_364)button2);
            }
            this.displayedLocations = new ArrayList<TextButton>();
            for (int i = offset = Math.min(this.mouseMovement, this.listSize - 12); i < 12 + offset; ++i) {
                LocationData data = this.allLocations.get(i);
                this.displayedLocations.add(new TextButton(x, y, 12, (class_2561)class_2561.method_43470((String)data.getName()), this.color, button -> this.locationButtonOnPress(data)));
                y += 16;
            }
            this.displayedLocations.forEach(x$0 -> {
                TextButton cfr_ignored_0 = (TextButton)this.method_37063((class_364)x$0);
            });
            this.listNeedsReload = false;
        }
    }

    private void renderOutline(class_4587 poseStack) {
        int lineWidth = 4;
        RunProgramScreen.method_25294((class_4587)poseStack, (int)((this.field_22789 - 480 - lineWidth) / 2), (int)((this.field_22790 - 256 - lineWidth) / 2), (int)((this.field_22789 + 480 + lineWidth) / 2), (int)((this.field_22790 + 256 + lineWidth) / 2), (int)(this.color | 0xFF000000));
    }

    private void renderGridBackground(class_4587 poseStack, float red, float green, float blue) {
        RenderSystem.setShaderTexture((int)0, (class_2960)GRID);
        RenderSystem.setShaderColor((float)(red * 0.5f), (float)(green * 0.5f), (float)(blue * 0.5f), (float)1.0f);
        RunProgramScreen.method_25293((class_4587)poseStack, (int)((this.field_22789 - 480) / 2), (int)((this.field_22790 - 256) / 2), (int)480, (int)256, (float)0.0f, (float)0.0f, (int)480, (int)256, (int)16, (int)16);
    }

    public void method_25433(class_4587 poseStack, int offset) {
        super.method_25433(poseStack, offset);
        float red = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.color & 0xFF) / 255.0f;
        this.renderOutline(poseStack);
        this.renderGridBackground(poseStack, red, green, blue);
        this.renderHeaders(poseStack);
    }

    private void renderHeaders(class_4587 matrices) {
        class_327 font = this.field_22787.field_1772;
        int cornerX = (this.field_22789 - 480) / 2 + 3;
        int cornerY = (this.field_22790 - 256) / 2 + 3;
        int x = cornerX + 240;
        int y = cornerY + 16;
        matrices.method_22903();
        matrices.method_22904((double)x * -0.5, (double)y * -0.5, 0.0);
        matrices.method_22905(1.5f, 1.5f, 0.0f);
        RunProgramScreen.method_27535((class_4587)matrices, (class_327)font, (class_2561)class_2561.method_43471((String)"gui.tempad.select_location"), (int)x, (int)y, (int)this.color);
        matrices.method_22909();
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(poseStack);
        super.method_25394(poseStack, mouseX, mouseY, partialTicks);
    }

    public boolean method_25421() {
        return false;
    }
}

