/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.smileycorp.atlas.api.block.IBlockProperties;

public class BlockBase
extends Block
implements IBlockProperties {
    protected String name;
    protected final String modid;
    public boolean isFlamable;

    public BlockBase(String name, String modid, Material material, SoundType sound, float h, float r, String tool, int level, CreativeTabs tab) {
        super(material);
        this.func_149752_b(r);
        this.func_149711_c(h);
        this.setHarvestLevel(tool, level);
        this.setRegistryName(new ResourceLocation(modid, name.toLowerCase()));
        this.func_149663_c(modid + "." + name.replace("_", ""));
        this.func_149647_a(tab);
        this.func_149672_a(sound);
        this.name = name;
        this.modid = modid;
        if (material == Material.field_151575_d) {
            this.isFlamable = true;
        }
    }

    public BlockBase(String name, String modid, Material material, SoundType sound, float h, float r, int level, CreativeTabs tab) {
        this(name, modid, material, sound, h, r, "pickaxe", level, tab);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.isFlamable ? 20 : super.getFlammability(world, pos, facing);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.isFlamable ? 5 : super.getFireSpreadSpeed(world, pos, facing);
    }

    public String getName() {
        return this.name;
    }

    public String getMod() {
        return this.modid;
    }
}

