/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block.wood;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.smileycorp.atlas.api.block.IBlockProperties;
import net.smileycorp.atlas.api.block.PropertyString;
import net.smileycorp.atlas.api.item.DummyItemBlock;

public class BlockBaseLeaves
extends BlockLeaves
implements IBlockProperties {
    protected static PropertyString staticProp;
    protected PropertyString prop;
    protected boolean isFlamable;
    protected List<ItemStack> saplings;
    boolean validated;

    protected BlockBaseLeaves(String name, String modid, CreativeTabs tab, List<String> variants, List<ItemStack> saplings, boolean isFlamable) {
        this.isFlamable = isFlamable;
        this.saplings = saplings;
        this.func_149647_a(tab);
        this.setRegistryName(new ResourceLocation(modid, name.toLowerCase()));
        this.func_149663_c(modid + "." + name.replace("_", ""));
        this.isFlamable = isFlamable;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)this.prop, (Comparable)((Object)variants.get(0))));
    }

    public static BlockBaseLeaves create(String name, String modid, CreativeTabs tab, List<String> variants, List<ItemStack> saplings, boolean isFlamable) {
        staticProp = new PropertyString("property", variants);
        return new BlockBaseLeaves(name, modid, tab, variants, saplings, isFlamable);
    }

    public PropertyString getProperty() {
        return this.prop;
    }

    protected BlockStateContainer func_180661_e() {
        this.prop = staticProp;
        return new BlockStateContainer((Block)this, new IProperty[]{field_176236_b, field_176237_a, this.prop});
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((Block)this));
        return drops;
    }

    @Override
    public int getMaxMeta() {
        return this.prop.getAllowedValues().size();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.isFlamable ? 20 : super.getFlammability(world, pos, facing);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.isFlamable ? 5 : super.getFireSpreadSpeed(world, pos, facing);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        ItemStack stack;
        this.tryValidate();
        int varMeta = this.func_176201_c(state) % 4;
        if (varMeta > this.saplings.size()) {
            varMeta = 0;
        }
        return (stack = this.saplings.get(varMeta)) == null ? null : stack.func_77973_b();
    }

    private void tryValidate() {
        if (!this.validated) {
            ArrayList<ItemStack> fixed = new ArrayList<ItemStack>();
            for (ItemStack stack : this.saplings) {
                if (stack == null) continue;
                if (stack.func_77973_b() instanceof DummyItemBlock) {
                    fixed.add(new ItemStack(Item.func_150898_a((Block)((DummyItemBlock)stack.func_77973_b()).block)));
                    continue;
                }
                fixed.add(stack);
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        int varMeta = this.prop.ordinal((String)((Object)state.func_177229_b((IProperty)this.prop)));
        if (varMeta > this.saplings.size()) {
            varMeta = 0;
        }
        return this.saplings.get(varMeta).func_77960_j();
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return null;
    }

    public boolean func_176225_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        this.field_185686_c = !Blocks.field_150362_t.func_149662_c(blockState);
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(meta >= 4 && meta < 8)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(meta <= 8)).func_177226_a((IProperty)this.prop, (Comparable)((Object)this.prop.getValue(meta % 4)));
    }

    public int func_176201_c(IBlockState state) {
        int varMeta = this.prop.ordinal((String)((Object)state.func_177229_b((IProperty)this.prop)));
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            return 4 + varMeta;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            return 8 + varMeta;
        }
        return varMeta;
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }
}

