/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.client;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextureAtlasGreyscale
extends TextureAtlasSprite {
    final ResourceLocation resource;

    public TextureAtlasGreyscale(ResourceLocation resource) {
        super(resource.toString() + "_grey");
        this.resource = resource;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.builder().addAll((Iterable)super.getDependencies()).add((Object)this.resource).build();
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        try {
            TextureAtlasSprite sprite = textureGetter.apply(this.resource);
            this.func_94217_a(sprite);
            int[][] spriteData = sprite.func_147965_a(0);
            int[][] data = (int[][])Arrays.stream(spriteData).map(rec$ -> (int[])((int[])rec$).clone()).toArray(x$0 -> new int[x$0][]);
            for (int i = 0; i < spriteData.length; ++i) {
                for (int j = 0; j < spriteData[i].length; ++j) {
                    int colour = spriteData[i][j];
                    int r = colour >> 16 & 0xFF;
                    int g = colour >> 8 & 0xFF;
                    int b = colour & 0xFF;
                    float rr = (float)Math.pow((double)r / 255.0, 2.2);
                    float gg = (float)Math.pow((double)g / 255.0, 2.2);
                    float bb = (float)Math.pow((double)b / 255.0, 2.2);
                    float l = 0.2126f * rr + 0.7152f * gg + 0.0722f * bb;
                    int grey = (int)(255.0 * Math.pow(l, 0.45454545454545453));
                    data[i][j] = new Color(grey, grey, grey, 255).getRGB();
                }
            }
            if (this.field_110976_a.size() < 1) {
                this.field_110976_a.add(data);
            } else {
                this.field_110976_a.set(0, data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

