/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.util;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class RecipeUtils {
    public static boolean compareItemStacks(ItemStack stack, ItemStack check, boolean useNBT) {
        if (stack == null || check == null) {
            return false;
        }
        if (check.func_77973_b() == stack.func_77973_b() && (check.func_77960_j() == Short.MAX_VALUE || check.func_77960_j() == stack.func_77960_j())) {
            if (!useNBT) {
                return true;
            }
            NBTTagCompound nbt1 = stack.func_77978_p();
            NBTTagCompound nbt2 = check.func_77978_p();
            if (nbt1 == null || nbt2 == null) {
                return nbt1 == nbt2;
            }
            return nbt1.equals((Object)nbt2);
        }
        return false;
    }

    public static boolean compareItemStacksCanFit(ItemStack stack, ItemStack check) {
        if (stack.func_190926_b() || check.func_190926_b()) {
            return true;
        }
        return RecipeUtils.compareItemStacks(stack, check, true) && stack.func_190916_E() + check.func_190916_E() <= stack.func_77976_d();
    }

    public static boolean compareItemStacksWithSize(ItemStack stack1, ItemStack stack2, boolean matchExactly) {
        if (RecipeUtils.compareItemStacks(stack1, stack2, true)) {
            if (stack1.func_190916_E() == stack2.func_190916_E()) {
                return true;
            }
            if (!matchExactly && stack1.func_190916_E() < stack2.func_190916_E()) {
                return true;
            }
        }
        return false;
    }

    public static boolean canResultsFitInSlots(List<ItemStack> outputList, List<ItemStack> slots, int amount) {
        for (ItemStack out : outputList) {
            amount = RecipeUtils.compareSlots(out, slots, amount);
            if (amount > 0) continue;
            return true;
        }
        return false;
    }

    private static int compareSlots(ItemStack out, List<ItemStack> slots, int amount) {
        for (ItemStack slot : slots) {
            if (!RecipeUtils.compareItemStacksCanFit(out, slot)) continue;
            return amount--;
        }
        for (ItemStack slot : slots) {
            if (!slot.func_190926_b()) continue;
            return amount--;
        }
        return amount;
    }
}

