/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class WeightedOutputs<T> {
    private final List<Map.Entry<T, Integer>> entries;
    private final int deafaultTries;

    public WeightedOutputs(Map<T, Integer> entries) {
        this(1, new ArrayList<Map.Entry<T, Integer>>(entries.entrySet()));
    }

    public WeightedOutputs(int deafultTries, Map<T, Integer> entries) {
        this(deafultTries, new ArrayList<Map.Entry<T, Integer>>(entries.entrySet()));
    }

    public WeightedOutputs(int deafaultTries, List<Map.Entry<T, Integer>> entries) {
        this.deafaultTries = deafaultTries;
        this.entries = entries;
    }

    public int getAmount() {
        return this.deafaultTries;
    }

    public List<Map.Entry<T, Integer>> getTable() {
        return new ArrayList<Map.Entry<T, Integer>>(this.entries);
    }

    public T getResult(Random rand) {
        return this.getResults(rand, 1).get(0);
    }

    public List<T> getResults(Random rand) {
        return this.getResults(rand, 1);
    }

    private List<T> getResults(Random rand, int tries) {
        ArrayList list = new ArrayList();
        ArrayList<AbstractMap.SimpleEntry<T, Integer>> mappedEntries = new ArrayList<AbstractMap.SimpleEntry<T, Integer>>();
        int max = 0;
        for (Map.Entry<T, Integer> entry : this.entries) {
            mappedEntries.add(new AbstractMap.SimpleEntry<T, Integer>(entry.getKey(), max));
            max += entry.getValue().intValue();
        }
        Collections.reverse(mappedEntries);
        block1: for (int i = 0; i < tries * this.deafaultTries; ++i) {
            int result = rand.nextInt(max);
            for (Map.Entry entry : mappedEntries) {
                if (result < (Integer)entry.getValue()) continue;
                list.add(entry.getKey());
                continue block1;
            }
        }
        return list;
    }
}

